/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class DeviceTestResult
extends TestResult {
    public void runProtected(Test test, Protectable p) {
        try {
            p.protect();
        }
        catch (AssertionFailedError e) {
            this.addFailure(test, e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (DeviceNotAvailableException e) {
            this.addError(test, e);
            throw new RuntimeDeviceNotAvailableException(e);
        }
        catch (Throwable e) {
            this.addError(test, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(final TestCase test) {
        this.startTest(test);
        Protectable p = new Protectable(){

            public void protect() throws Throwable {
                test.runBare();
            }
        };
        try {
            this.runProtected(test, p);
        }
        finally {
            this.endTest(test);
        }
    }

    public class RuntimeDeviceNotAvailableException
    extends RuntimeException {
        private DeviceNotAvailableException mException;

        RuntimeDeviceNotAvailableException(DeviceNotAvailableException e) {
            super(e.getMessage());
            this.mException = e;
        }

        DeviceNotAvailableException getDeviceException() {
            return this.mException;
        }
    }
}

