/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.GTestResultParser;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;

@OptionClass(alias="gtest")
public class GTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "GTest";
    static final String DEFAULT_NATIVETEST_PATH = "/data/nativetest";
    private ITestDevice mDevice = null;
    private boolean mRunDisabledTests = false;
    @Option(name="native-test-device-path", description="The path on the device where native tests are located.")
    private String mNativeTestDevicePath = "/data/nativetest";
    @Option(name="module-name", description="The name of the native test module to run.")
    private String mTestModule = null;
    @Option(name="positive-testname-filter", description="The GTest-based positive filter of the test name to run.")
    private String mTestNamePositiveFilter = null;
    @Option(name="negative-testname-filter", description="The GTest-based negative filter of the test name to run.")
    private String mTestNameNegativeFilter = null;
    @Option(name="native-test-timeout", description="The max time in ms for a gtest to run. Test run will be aborted if any test takes longer.")
    private int mMaxTestTimeMs = 60000;
    @Option(name="send-coverage", description="Send coverage target info to test listeners.")
    private boolean mSendCoverage = true;
    private static final String COVERAGE_TARGET = "Native";
    private static final String GTEST_FLAG_PRINT_TIME = "--gtest_print_time";
    private static final String GTEST_FLAG_FILTER = "--gtest_filter";
    private static final String GTEST_FLAG_RUN_DISABLED_TESTS = "--gtest_also_run_disabled_tests";

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setModuleName(String moduleName) {
        this.mTestModule = moduleName;
    }

    public String getModuleName(String moduleName) {
        return this.mTestModule;
    }

    public void setRunDisabled(boolean runDisabled) {
        this.mRunDisabledTests = runDisabled;
    }

    public boolean getRunDisabledTests() {
        return this.mRunDisabledTests;
    }

    void setMaxTestTimeMs(int timeout) {
        this.mMaxTestTimeMs = timeout;
    }

    public void setTestNamePositiveFilter(String testName) {
        this.mTestNamePositiveFilter = testName;
    }

    public String getTestNamePositiveFilter() {
        return this.mTestNamePositiveFilter;
    }

    public void setTestNameNegativeFilter(String testName) {
        this.mTestNameNegativeFilter = testName;
    }

    public String getTestNameNegativeFilter() {
        return this.mTestNameNegativeFilter;
    }

    private String getGTestFilters() {
        String filter = "";
        if (this.mTestNamePositiveFilter != null || this.mTestNameNegativeFilter != null) {
            filter = "--gtest_filter=";
            if (this.mTestNamePositiveFilter != null) {
                filter = String.format("%s*.%s", filter, this.mTestNamePositiveFilter);
            }
            if (this.mTestNameNegativeFilter != null) {
                filter = String.format("%s-*.%s", filter, this.mTestNameNegativeFilter);
            }
        }
        return filter;
    }

    private String getAllGTestFlags() {
        String flags = String.format("%s %s", GTEST_FLAG_PRINT_TIME, this.getGTestFilters());
        if (this.mRunDisabledTests) {
            flags = String.format("%s %s", flags, GTEST_FLAG_RUN_DISABLED_TESTS);
        }
        return flags;
    }

    private String getTestPath() {
        StringBuilder testPath = new StringBuilder(this.mNativeTestDevicePath);
        if (this.mTestModule != null) {
            testPath.append("/");
            testPath.append(this.mTestModule);
        }
        return testPath.toString();
    }

    void doRunAllTestsInSubdirectory(IFileEntry rootEntry, ITestDevice testDevice, ITestRunListener listener) throws DeviceNotAvailableException {
        if (rootEntry.isDirectory()) {
            for (IFileEntry childEntry : rootEntry.getChildren(true)) {
                this.doRunAllTestsInSubdirectory(childEntry, testDevice, listener);
            }
        } else {
            IShellOutputReceiver resultParser = this.createResultParser(rootEntry.getName(), listener);
            String fullPath = rootEntry.getFullEscapedPath();
            String flags = this.getAllGTestFlags();
            Log.i((String)LOG_TAG, (String)String.format("Running gtest %s %s on %s", fullPath, flags, this.mDevice.getSerialNumber()));
            testDevice.executeShellCommand(String.format("chmod 755 %s", fullPath));
            this.runTest(testDevice, resultParser, fullPath, flags);
        }
    }

    private void runTest(ITestDevice testDevice, IShellOutputReceiver resultParser, String fullPath, String flags) throws DeviceNotAvailableException {
        try {
            testDevice.executeShellCommand(String.format("%s %s", fullPath, flags), resultParser, this.mMaxTestTimeMs, 0);
        }
        catch (DeviceNotAvailableException e) {
            resultParser.flush();
            throw e;
        }
        catch (RuntimeException e) {
            resultParser.flush();
            throw e;
        }
    }

    IShellOutputReceiver createResultParser(String runName, ITestRunListener listener) {
        GTestResultParser resultParser = new GTestResultParser(runName, listener);
        if (this.mSendCoverage) {
            resultParser.setCoverageTarget(COVERAGE_TARGET);
        }
        return resultParser;
    }

    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        String testPath = this.getTestPath();
        IFileEntry nativeTestDirectory = this.mDevice.getFileEntry(testPath);
        if (nativeTestDirectory == null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not find native test directory %s in %s!", testPath, this.mDevice.getSerialNumber()));
            return;
        }
        this.doRunAllTestsInSubdirectory(nativeTestDirectory, this.mDevice, listener);
    }
}

