/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IResumableTest;
import com.android.tradefed.testtype.InstrumentationTest;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="installed-instrumentation")
public class InstalledInstrumentationsTest
implements IDeviceTest,
IResumableTest {
    public static final String COVERAGE_TARGET_KEY = "coverage_target";
    private static final Pattern LIST_INSTR_PATTERN = Pattern.compile("instrumentation:(.+)/(.+) \\(target=(.+)\\)");
    private ITestDevice mDevice;
    @Option(name="timeout", description="Fail any test that takes longer than the specified number of milliseconds.")
    private int mTestTimeout = 600000;
    @Option(name="size", description="Restrict tests to a specific test size. One of 'small', 'medium', 'large'", importance=Option.Importance.IF_UNSET)
    private String mTestSize = null;
    @Option(name="rerun", description="Rerun unexecuted tests individually on same device if test run fails to complete.")
    private boolean mIsRerunMode = true;
    @Option(name="resume", description="Schedule unexecuted tests for resumption on another device if first device becomes unavailable.")
    private boolean mIsResumeMode = false;
    @Option(name="send-coverage", description="Send coverage target info to test listeners.")
    private boolean mSendCoverage = true;
    private List<InstrumentationTest> mTests = null;

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    void setSendCoverage(boolean sendCoverage) {
        this.mSendCoverage = sendCoverage;
    }

    List<InstrumentationTest> getTests() {
        return this.mTests;
    }

    @Override
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.getDevice() == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        this.buildTests();
        this.doRun(listener);
    }

    private void buildTests() throws DeviceNotAvailableException {
        if (this.mTests == null) {
            ListInstrumentationParser parser = new ListInstrumentationParser();
            this.getDevice().executeShellCommand("pm list instrumentation", (IShellOutputReceiver)parser);
            if (parser.getParsedTests().isEmpty()) {
                throw new IllegalArgumentException(String.format("No instrumentations were found on device %s", this.getDevice().getSerialNumber()));
            }
            this.mTests = parser.getParsedTests();
        }
    }

    private void doRun(ITestInvocationListener listener) throws DeviceNotAvailableException {
        while (!this.mTests.isEmpty()) {
            InstrumentationTest test = this.mTests.get(0);
            LogUtil.CLog.d("Running test %s on %s", test.getPackageName(), this.getDevice().getSerialNumber());
            if (this.mSendCoverage && test.getCoverageTarget() != null) {
                this.sendCoverage(test.getPackageName(), test.getCoverageTarget(), listener);
            }
            test.setDevice(this.getDevice());
            test.run(listener);
            this.mTests.remove(0);
        }
    }

    private void sendCoverage(String packageName, String coverageTarget, ITestInvocationListener listener) {
        HashMap<String, String> coverageMetric = new HashMap<String, String>(1);
        coverageMetric.put(COVERAGE_TARGET_KEY, coverageTarget);
        listener.testRunStarted(packageName, 0);
        listener.testRunEnded(0L, coverageMetric);
    }

    int getTestTimeout() {
        return this.mTestTimeout;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    InstrumentationTest createInstrumentationTest() {
        return new InstrumentationTest();
    }

    @Override
    public boolean isResumable() {
        if (this.mTests == null) {
            return false;
        }
        return this.mIsResumeMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListInstrumentationParser
    extends MultiLineReceiver {
        private List<InstrumentationTest> mTests = new LinkedList<InstrumentationTest>();

        private ListInstrumentationParser() {
        }

        public boolean isCancelled() {
            return false;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                Matcher m = LIST_INSTR_PATTERN.matcher(line);
                if (!m.find()) continue;
                InstrumentationTest t = InstalledInstrumentationsTest.this.createInstrumentationTest();
                t.setPackageName(m.group(1));
                t.setRunnerName(m.group(2));
                t.setCoverageTarget(m.group(3));
                t.setRerunMode(InstalledInstrumentationsTest.this.mIsRerunMode);
                t.setResumeMode(InstalledInstrumentationsTest.this.mIsResumeMode);
                t.setTestSize(InstalledInstrumentationsTest.this.getTestSize());
                t.setTestTimeout(InstalledInstrumentationsTest.this.getTestTimeout());
                this.mTests.add(t);
            }
        }

        public List<InstrumentationTest> getParsedTests() {
            return this.mTests;
        }
    }
}

