/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IResumableTest;
import com.android.tradefed.testtype.InstrumentationListTest;
import com.android.tradefed.util.StringEscapeUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="instrumentation")
public class InstrumentationTest
implements IDeviceTest,
IResumableTest {
    private static final String LOG_TAG = "InstrumentationTest";
    private static final int COLLECT_TESTS_ATTEMPTS = 3;
    static final String DELAY_MSEC_ARG = "delay_msec";
    @Option(name="package", shortName=112, description="The manifest package name of the Android test application to run.", importance=Option.Importance.IF_UNSET)
    private String mPackageName = null;
    @Option(name="runner", description="The instrumentation test runner class name to use.")
    private String mRunnerName = "android.test.InstrumentationTestRunner";
    @Option(name="class", shortName=99, description="The test class name to run.")
    private String mTestClassName = null;
    @Option(name="method", shortName=109, description="The test method name to run.")
    private String mTestMethodName = null;
    @Option(name="test-package", description="Only run tests within this specific java package. Will be ignored if --class is set.")
    private String mTestPackageName = null;
    @Option(name="timeout", description="Aborts the test run if any test takes longer than the specified number of milliseconds. For no timeout, set to 0.")
    private int mTestTimeout = 600000;
    @Option(name="size", description="Restrict test to a specific test size.")
    private String mTestSize = null;
    @Option(name="rerun", description="Rerun unexecuted tests individually on same device if test run fails to complete.")
    private boolean mIsRerunMode = true;
    @Option(name="resume", description="Schedule unexecuted tests for resumption on another device if first device becomes unavailable.")
    private boolean mIsResumeMode = false;
    @Option(name="log-delay", description="Delay in msec between each test when collecting test information.")
    private int mTestDelay = 15;
    @Option(name="install-file", description="Optional file path to apk file that contains the tests.")
    private File mInstallFile = null;
    @Option(name="run-name", description="Optional custom test run name to pass to listener. If unspecified, will use package name.")
    private String mRunName = null;
    @Option(name="instrumentation-arg", description="Additional instrumentation arguments to provide.")
    private Map<String, String> mInstrArgMap = new HashMap<String, String>();
    private ITestDevice mDevice = null;
    private IRemoteAndroidTestRunner mRunner;
    private Collection<TestIdentifier> mRemainingTests = null;
    private String mCoverageTarget = null;
    private int mCollectTestsShellTimeout = 120000;
    private boolean mForceBatchMode = false;

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    public void setRunnerName(String runnerName) {
        this.mRunnerName = runnerName;
    }

    public String getRunnerName() {
        return this.mRunnerName;
    }

    public void setClassName(String testClassName) {
        this.mTestClassName = testClassName;
    }

    public void setMethodName(String testMethodName) {
        this.mTestMethodName = StringEscapeUtils.escapeShell(testMethodName);
    }

    public void setTestSize(String size) {
        this.mTestSize = size;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getRunName() {
        return this.mRunName;
    }

    public void setRunName(String runName) {
        this.mRunName = runName;
    }

    public void setTestsToRun(Collection<TestIdentifier> tests, boolean forceBatchMode) {
        this.mRemainingTests = tests;
        this.mForceBatchMode = forceBatchMode;
    }

    String getClassName() {
        return this.mTestClassName;
    }

    String getMethodName() {
        return this.mTestMethodName;
    }

    String getTestPackageName() {
        return this.mTestPackageName;
    }

    public void setTestPackageName(String testPackageName) {
        this.mTestPackageName = testPackageName;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    public void setTestTimeout(int timeout) {
        this.mTestTimeout = timeout;
    }

    public void setCoverageTarget(String coverageTarget) {
        this.mCoverageTarget = coverageTarget;
    }

    public String getCoverageTarget() {
        return this.mCoverageTarget;
    }

    boolean isRerunMode() {
        return this.mIsRerunMode;
    }

    @Override
    public boolean isResumable() {
        if (this.mRemainingTests == null) {
            return false;
        }
        return this.mIsResumeMode;
    }

    public void setRerunMode(boolean rerun) {
        this.mIsRerunMode = rerun;
    }

    public void setResumeMode(boolean resume) {
        this.mIsResumeMode = resume;
    }

    int getTestTimeout() {
        return this.mTestTimeout;
    }

    long getTestDelay() {
        return this.mTestDelay;
    }

    public void setInstallFile(File installFile) {
        this.mInstallFile = installFile;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setCollectsTestsShellTimeout(int timeout) {
        this.mCollectTestsShellTimeout = timeout;
    }

    public void addInstrumentationArg(String key, String value) {
        this.mInstrArgMap.put(key, value);
    }

    IRemoteAndroidTestRunner createRemoteAndroidTestRunner(String packageName, String runnerName, IDevice device) {
        return new RemoteAndroidTestRunner(packageName, runnerName, device);
    }

    @Override
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mPackageName == null) {
            throw new IllegalArgumentException("package name has not been set");
        }
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        this.mRunner = this.createRemoteAndroidTestRunner(this.mPackageName, this.mRunnerName, this.mDevice.getIDevice());
        if (this.mTestClassName != null) {
            if (this.mTestMethodName != null) {
                this.mRunner.setMethodName(this.mTestClassName, this.mTestMethodName);
            } else {
                this.mRunner.setClassName(this.mTestClassName);
            }
        } else if (this.mTestPackageName != null) {
            this.mRunner.setTestPackageName(this.mTestPackageName);
        }
        if (this.mTestSize != null) {
            this.mRunner.setTestSize(IRemoteAndroidTestRunner.TestSize.getTestSize((String)this.mTestSize));
        }
        this.mRunner.setMaxtimeToOutputResponse(this.mTestTimeout);
        if (this.mRunName != null) {
            this.mRunner.setRunName(this.mRunName);
        }
        for (Map.Entry<String, String> argEntry : this.mInstrArgMap.entrySet()) {
            this.mRunner.addInstrumentationArg(argEntry.getKey(), argEntry.getValue());
        }
        if (this.mInstallFile != null) {
            this.mDevice.installPackage(this.mInstallFile, true, new String[0]);
            this.doTestRun(listener);
            this.mDevice.uninstallPackage(this.mPackageName);
        } else {
            this.doTestRun(listener);
        }
    }

    private void doTestRun(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mRemainingTests != null && !this.mForceBatchMode) {
            this.rerunTests(listener);
            return;
        }
        if (this.mRemainingTests == null) {
            this.mRemainingTests = this.collectTestsToRun(this.mRunner);
        }
        if (this.mRemainingTests == null) {
            this.mDevice.runInstrumentationTests(this.mRunner, listener);
        } else if (this.mRemainingTests.size() != 0) {
            this.runWithRerun(listener, this.mRemainingTests);
        } else {
            Log.i((String)LOG_TAG, (String)String.format("No tests expected for %s, skipping", this.mPackageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithRerun(ITestInvocationListener listener, Collection<TestIdentifier> expectedTests) throws DeviceNotAvailableException {
        CollectingTestListener testTracker = new CollectingTestListener();
        this.mRemainingTests = expectedTests;
        try {
            this.mDevice.runInstrumentationTests(this.mRunner, new ResultForwarder(listener, testTracker));
        }
        finally {
            this.calculateRemainingTests(this.mRemainingTests, testTracker);
        }
        this.rerunTests(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rerunTests(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mRemainingTests.size() > 0) {
            InstrumentationListTest testRerunner = new InstrumentationListTest(this.mPackageName, this.mRunnerName, this.mRemainingTests);
            testRerunner.setDevice(this.getDevice());
            testRerunner.setTestTimeout(this.getTestTimeout());
            testRerunner.setRunName(this.mRunName);
            CollectingTestListener testTracker = new CollectingTestListener();
            try {
                testRerunner.run(new ResultForwarder(listener, testTracker));
            }
            finally {
                this.calculateRemainingTests(this.mRemainingTests, testTracker);
            }
        }
    }

    private void calculateRemainingTests(Collection<TestIdentifier> expectedTests, CollectingTestListener testTracker) {
        expectedTests.removeAll(testTracker.getCurrentRunResults().getCompletedTests());
    }

    private Collection<TestIdentifier> collectTestsToRun(IRemoteAndroidTestRunner runner) throws DeviceNotAvailableException {
        if (this.isRerunMode()) {
            Log.d((String)LOG_TAG, (String)String.format("Collecting test info for %s on device %s", this.mPackageName, this.mDevice.getSerialNumber()));
            runner.setLogOnly(true);
            if (this.mTestDelay > 0) {
                runner.addInstrumentationArg(DELAY_MSEC_ARG, Integer.toString(this.mTestDelay));
            }
            runner.setMaxtimeToOutputResponse(this.mCollectTestsShellTimeout);
            Collection<TestIdentifier> tests = this.collectTestsAndRetry(runner);
            runner.setLogOnly(false);
            runner.setMaxtimeToOutputResponse(this.mTestTimeout);
            runner.removeInstrumentationArg(DELAY_MSEC_ARG);
            return tests;
        }
        return null;
    }

    private Collection<TestIdentifier> collectTestsAndRetry(IRemoteAndroidTestRunner runner) throws DeviceNotAvailableException {
        boolean communicationFailure = false;
        for (int i = 0; i < 3; ++i) {
            CollectingTestListener listener = new CollectingTestListener();
            boolean instrResult = this.mDevice.runInstrumentationTests(runner, listener);
            TestRunResult runResults = listener.getCurrentRunResults();
            if (instrResult && runResults.isRunComplete()) {
                if (runResults.isRunFailure()) {
                    LogUtil.CLog.w("Run failure %s when collecting tests to run for %s on device %s.", runResults.getRunFailureMessage(), this.mPackageName, this.mDevice.getSerialNumber());
                    return null;
                }
                return runResults.getCompletedTests();
            }
            Log.w((String)LOG_TAG, (String)String.format("No results when collecting tests to run for %s on device %s. Retrying", this.mPackageName, this.mDevice.getSerialNumber()));
            communicationFailure = true;
        }
        if (communicationFailure) {
            LogUtil.CLog.w("Ignoring repeated communication failure when collecting tests %s for device %s", this.mPackageName, this.mDevice.getSerialNumber());
        }
        LogUtil.CLog.e("Failed to collect tests to run for %s on device %s.", this.mPackageName, this.mDevice.getSerialNumber());
        return null;
    }
}

