/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.JUnitToInvocationResultForwarder;
import com.android.tradefed.testtype.DeviceTestResult;
import java.util.Collections;
import java.util.Map;
import junit.framework.Test;

public class JUnitRunUtil {
    public static void runTest(ITestInvocationListener listener, Test junitTest) throws DeviceNotAvailableException {
        JUnitRunUtil.runTest(listener, junitTest, junitTest.getClass().getName());
    }

    public static void runTest(ITestInvocationListener listener, Test junitTest, String runName) throws DeviceNotAvailableException {
        listener.testRunStarted(runName, junitTest.countTestCases());
        long startTime = System.currentTimeMillis();
        JUnitToInvocationResultForwarder resultForwarder = new JUnitToInvocationResultForwarder(listener);
        DeviceTestResult result = new DeviceTestResult();
        result.addListener(resultForwarder);
        try {
            junitTest.run(result);
        }
        catch (DeviceTestResult.RuntimeDeviceNotAvailableException e) {
            listener.testRunFailed(e.getDeviceException().getMessage());
            throw e.getDeviceException();
        }
        finally {
            Map emptyMap = Collections.emptyMap();
            listener.testRunEnded(System.currentTimeMillis() - startTime, emptyMap);
        }
    }
}

