/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.InstrumentationResultParser;
import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiAutomatorRunner
implements IRemoteAndroidTestRunner {
    private static final String CLASS_ARG_NAME = "class";
    private static final String DEBUG_ARG_NAME = "debug";
    private static final String RUNNER_ARG_NAME = "runner";
    private static final char METHOD_SEPARATOR = '#';
    private static final char CLASS_SEPARATOR = ',';
    private static final String DEFAULT_RUNNER_NAME = "com.android.uiautomator.testrunner.UiAutomatorTestRunner";
    private static final String UIAUTOMATOR_RUNNER_PATH = "/system/bin/uiautomator";
    private Map<String, String> mArgsMap;
    private String[] mJarPaths;
    private String mPackageName;
    private int mMaxTimeToOutputResponse = 0;
    private IDevice mRemoteDevice;
    private String mRunName;
    private InstrumentationResultParser mParser;
    private String mRunnerPath = "/system/bin/uiautomator";
    private String mRunnerName = "com.android.uiautomator.testrunner.UiAutomatorTestRunner";

    public UiAutomatorRunner(IDevice remoteDevice, String[] jarPaths, String[] classes, String runnerPath) {
        this.mRemoteDevice = remoteDevice;
        this.mJarPaths = jarPaths;
        this.mArgsMap = new LinkedHashMap<String, String>();
        if (runnerPath != null) {
            this.mRunnerPath = runnerPath;
        }
        this.setClassNames(classes);
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getRunnerName() {
        return this.mRunnerName;
    }

    protected String getRunnerPath() {
        return this.mRunnerPath;
    }

    protected String getRunCommand() {
        StringBuilder jarArg = new StringBuilder();
        jarArg.append(this.mJarPaths[0]);
        for (int i = 1; i < this.mJarPaths.length; ++i) {
            jarArg.append(' ');
            jarArg.append(this.mJarPaths[i]);
        }
        return String.format("%s runtest %s %s", this.getRunnerPath(), jarArg.toString(), this.getArgsCommand());
    }

    private String getArgsCommand() {
        StringBuilder commandBuilder = new StringBuilder();
        for (Map.Entry<String, String> argPair : this.mArgsMap.entrySet()) {
            String argCmd = String.format(" -e %1$s %2$s", argPair.getKey(), argPair.getValue());
            commandBuilder.append(argCmd);
        }
        return commandBuilder.toString();
    }

    public void setClassName(String className) {
        int pos = className.lastIndexOf(46);
        this.mPackageName = pos == -1 ? "(default)" : className.substring(0, pos);
        this.addInstrumentationArg(CLASS_ARG_NAME, className);
    }

    public void setClassNames(String[] classNames) {
        StringBuilder classArgBuilder = new StringBuilder();
        for (int i = 0; i < classNames.length; ++i) {
            if (i != 0) {
                classArgBuilder.append(',');
            }
            classArgBuilder.append(classNames[i]);
        }
        this.setClassName(classArgBuilder.toString());
    }

    public void setMethodName(String className, String testName) {
        this.setClassName(className + '#' + testName);
    }

    public void setTestPackageName(String packageName) {
        throw new UnsupportedOperationException("specifying package name is not supported");
    }

    public void setTestSize(IRemoteAndroidTestRunner.TestSize size) {
        throw new UnsupportedOperationException("specifying test size is not supported");
    }

    public void addInstrumentationArg(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (RUNNER_ARG_NAME.equals(name)) {
            this.mRunnerName = name;
        }
        this.mArgsMap.put(name, value);
    }

    public void removeInstrumentationArg(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.mArgsMap.remove(name);
    }

    public void addBooleanArg(String name, boolean value) {
        this.addInstrumentationArg(name, Boolean.toString(value));
    }

    public void setLogOnly(boolean logOnly) {
        throw new UnsupportedOperationException("log only mode is not supported");
    }

    public void setDebug(boolean debug) {
        this.addBooleanArg(DEBUG_ARG_NAME, debug);
    }

    public void setCoverage(boolean coverage) {
        throw new UnsupportedOperationException("coverage mode is not supported");
    }

    public void setMaxtimeToOutputResponse(int maxTimeToOutputResponse) {
        this.mMaxTimeToOutputResponse = maxTimeToOutputResponse;
    }

    public void setRunName(String runName) {
        this.mRunName = runName;
    }

    public void run(ITestRunListener ... listeners) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.run(Arrays.asList(listeners));
    }

    public void run(Collection<ITestRunListener> listeners) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String cmdLine = this.getRunCommand();
        LogUtil.CLog.i("Running %s on %s", cmdLine, this.mRemoteDevice.getSerialNumber());
        String runName = this.mRunName == null ? this.mPackageName : this.mRunName;
        this.mParser = new InstrumentationResultParser(runName, listeners);
        try {
            this.mRemoteDevice.executeShellCommand(cmdLine, (IShellOutputReceiver)this.mParser, this.mMaxTimeToOutputResponse);
        }
        catch (IOException e) {
            LogUtil.CLog.w(String.format("IOException %1$s when running tests %2$s on %3$s", e.toString(), this.getPackageName(), this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(e.toString());
            throw e;
        }
        catch (ShellCommandUnresponsiveException e) {
            LogUtil.CLog.w("ShellCommandUnresponsiveException %1$s when running tests %2$s on %3$s", e.toString(), this.getPackageName(), this.mRemoteDevice.getSerialNumber());
            this.mParser.handleTestRunFailed(String.format("Failed to receive adb shell test output within %1$d ms. Test may have timed out, or adb connection to device became unresponsive", this.mMaxTimeToOutputResponse));
            throw e;
        }
        catch (TimeoutException e) {
            LogUtil.CLog.w("TimeoutException when running tests %1$s on %2$s", this.getPackageName(), this.mRemoteDevice.getSerialNumber());
            this.mParser.handleTestRunFailed(e.toString());
            throw e;
        }
        catch (AdbCommandRejectedException e) {
            LogUtil.CLog.w("AdbCommandRejectedException %1$s when running tests %2$s on %3$s", e.toString(), this.getPackageName(), this.mRemoteDevice.getSerialNumber());
            this.mParser.handleTestRunFailed(e.toString());
            throw e;
        }
    }

    public void cancel() {
        if (this.mParser != null) {
            this.mParser.cancel();
        }
    }
}

