/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.StubTestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.UiAutomatorRunner;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiAutomatorTest
implements IRemoteTest,
IDeviceTest {
    private static final String SHELL_EXE_BASE = "/data/local/tmp/";
    private ITestDevice mDevice = null;
    private UiAutomatorRunner mRunner = null;
    @Option(name="jar-path", description="path to jars containing UI Automator test cases and dependencies; May be repeated.", mandatory=true)
    private List<String> mJarPaths = new ArrayList<String>();
    @Option(name="class", description="test class to run, may be repeated; multiple classess will be run in the same order as provided in command line", mandatory=true)
    private List<String> mClasses = new ArrayList<String>();
    @Option(name="sync-time", description="time to allow for initial sync, in ms")
    private long mSyncTime = 0L;
    @Option(name="run-arg", description="Additional test specific arguments to provide.")
    private Map<String, String> mArgMap = new LinkedHashMap<String, String>();
    @Option(name="timeout", description="Aborts the test run if any test takes longer than the specified number of milliseconds. For no timeout, set to 0.")
    private int mTestTimeout = 1800000;
    @Option(name="capture-logs", description="capture bugreport and screenshot after each failed test")
    private boolean mCaptureLogs = true;
    @Option(name="runner-path", description="path to uiautomator runner; may be null and default will be used in this case")
    private String mRunnerPath = null;
    private String mRunName;

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setCaptureLogs(boolean captureLogs) {
        this.mCaptureLogs = captureLogs;
    }

    public void setRunName(String runName) {
        this.mRunName = runName;
    }

    @Override
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mRunner = new UiAutomatorRunner(this.getDevice().getIDevice(), this.getTestJarPaths().toArray(new String[0]), this.mClasses.toArray(new String[0]), this.mRunnerPath);
        this.mRunner.setRunName(this.mRunName);
        this.preTestSetup();
        this.getRunUtil().sleep(this.getSyncTime());
        this.mRunner.setMaxtimeToOutputResponse(this.mTestTimeout);
        for (Map.Entry<String, String> entry : this.getTestRunArgMap().entrySet()) {
            this.getTestRunner().addInstrumentationArg(entry.getKey(), entry.getValue());
        }
        if (this.mCaptureLogs) {
            this.getDevice().runInstrumentationTests((IRemoteAndroidTestRunner)this.getTestRunner(), listener, new FailureReportWrapper(listener));
        } else {
            this.getDevice().runInstrumentationTests((IRemoteAndroidTestRunner)this.getTestRunner(), listener);
        }
    }

    public void addRunArg(String key, String value) {
        this.getTestRunArgMap().put(key, value);
    }

    protected void preTestSetup() throws DeviceNotAvailableException {
        String runnerPath = this.getTestRunner().getRunnerPath();
        if (!this.getDevice().doesFileExist(runnerPath)) {
            throw new RuntimeException("Missing UI Automator runner: " + runnerPath);
        }
        for (String jarPath : this.getTestJarPaths()) {
            if (!jarPath.startsWith("/")) {
                jarPath = SHELL_EXE_BASE + jarPath;
            }
            if (this.getDevice().doesFileExist(jarPath)) continue;
            throw new RuntimeException("Missing UI Automator test jar on device: " + jarPath);
        }
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public long getSyncTime() {
        return this.mSyncTime;
    }

    public void setSyncTime(long syncTime) {
        this.mSyncTime = syncTime;
    }

    public UiAutomatorRunner getTestRunner() {
        return this.mRunner;
    }

    public List<String> getTestJarPaths() {
        return this.mJarPaths;
    }

    public void setTestJarPaths(List<String> jarPaths) {
        this.mJarPaths = jarPaths;
    }

    public Map<String, String> getTestRunArgMap() {
        return this.mArgMap;
    }

    public void setTestRunArgMap(Map<String, String> runArgMap) {
        this.mArgMap = runArgMap;
    }

    public void addClassName(String className) {
        this.mClasses.add(className);
    }

    public void addClassNames(Collection<String> classNames) {
        this.mClasses.addAll(classNames);
    }

    private class FailureReportWrapper
    extends StubTestInvocationListener {
        ITestInvocationListener mListener;

        public FailureReportWrapper(ITestInvocationListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
            InputStreamSource data = null;
            try {
                data = UiAutomatorTest.this.getDevice().getScreenshot();
                this.mListener.testLog(test.getTestName() + "_failure_screenshot.png", LogDataType.PNG, data);
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e(e);
            }
            finally {
                if (data != null) {
                    data.cancel();
                }
            }
            data = UiAutomatorTest.this.getDevice().getBugreport();
            this.mListener.testLog(test.getTestName() + "_failure_bugreport.txt", LogDataType.TEXT, data);
            if (data != null) {
                data.cancel();
            }
        }
    }
}

