/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.testdefs;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IResumableTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.testtype.testdefs.InstrumentationTestDef;
import com.android.tradefed.testtype.testdefs.XmlDefsParser;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="xml-defs")
public class XmlDefsTest
implements IDeviceTest,
IResumableTest,
IShardableTest {
    private static final String LOG_TAG = "XmlDefsTest";
    public static final String COVERAGE_TARGET_KEY = "coverage_target";
    private ITestDevice mDevice;
    @Option(name="timeout", description="Fail any test that takes longer than the specified number of milliseconds.")
    private int mTestTimeout = 600000;
    @Option(name="size", description="Restrict tests to a specific test size. One of 'small', 'medium', 'large'", importance=Option.Importance.IF_UNSET)
    private String mTestSize = null;
    @Option(name="rerun", description="Rerun unexecuted tests individually on same device if test run fails to complete.")
    private boolean mIsRerunMode = true;
    @Option(name="resume", description="Schedule unexecuted tests for resumption on another device if first device becomes unavailable.")
    private boolean mIsResumeMode = false;
    @Option(name="local-file-path", description="local file path to test_defs.xml file to run.")
    private Collection<File> mLocalFiles = new ArrayList<File>();
    @Option(name="device-file-path", description="file path on device to test_defs.xml file to run.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mRemotePaths = new ArrayList<String>();
    @Option(name="send-coverage", description="Send coverage target info to test listeners.")
    private boolean mSendCoverage = true;
    @Option(name="num-shards", description="Shard this test into given number of separately runnable chunks.")
    private int mNumShards = 0;
    private List<InstrumentationTest> mTests = null;

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    void addRemoteFilePath(String path) {
        this.mRemotePaths.add(path);
    }

    void addLocalFilePath(File file) {
        this.mLocalFiles.add(file);
    }

    void setSendCoverage(boolean sendCoverage) {
        this.mSendCoverage = sendCoverage;
    }

    void setNumShards(int shards) {
        this.mNumShards = shards;
    }

    List<InstrumentationTest> getTests() {
        return this.mTests;
    }

    @Override
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.getDevice() == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        this.buildTests();
        this.doRun(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTests() throws DeviceNotAvailableException {
        if (this.mTests == null) {
            if (this.mLocalFiles.isEmpty() && this.mRemotePaths.isEmpty()) {
                throw new IllegalArgumentException("No test definition files (local-file-path or device-file-path) have been provided.");
            }
            XmlDefsParser parser = this.createParser();
            for (File testDefFile : this.mLocalFiles) {
                this.parseFile(parser, testDefFile);
            }
            for (File testDefFile : this.getRemoteFile(this.mRemotePaths)) {
                try {
                    this.parseFile(parser, testDefFile);
                }
                finally {
                    testDefFile.delete();
                }
            }
            this.mTests = new LinkedList<InstrumentationTest>();
            for (InstrumentationTestDef def : parser.getTestDefs()) {
                if (!def.isContinuous()) continue;
                InstrumentationTest test = this.createInstrumentationTest();
                test.setDevice(this.getDevice());
                test.setPackageName(def.getPackage());
                if (def.getRunner() != null) {
                    test.setRunnerName(def.getRunner());
                }
                if (def.getClassName() != null) {
                    test.setClassName(def.getClassName());
                }
                test.setRerunMode(this.mIsRerunMode);
                test.setResumeMode(this.mIsResumeMode);
                test.setTestSize(this.getTestSize());
                test.setTestTimeout(this.getTestTimeout());
                test.setCoverageTarget(def.getCoverageTarget());
                this.mTests.add(test);
            }
        }
    }

    private void parseFile(XmlDefsParser parser, File testDefFile) {
        try {
            Log.i((String)LOG_TAG, (String)String.format("Parsing test def file %s", testDefFile.getAbsolutePath()));
            parser.parse(new FileInputStream(testDefFile));
        }
        catch (FileNotFoundException e) {
            Log.e((String)LOG_TAG, (String)String.format("Could not find test def file %s", testDefFile.getAbsolutePath()));
        }
        catch (AbstractXmlParser.ParseException e) {
            Log.e((String)LOG_TAG, (String)String.format("Could not parse test def file %s: %s", testDefFile.getAbsolutePath(), e.getMessage()));
        }
    }

    private void doRun(ITestInvocationListener listener) throws DeviceNotAvailableException {
        while (!this.mTests.isEmpty()) {
            InstrumentationTest test = this.mTests.get(0);
            Log.d((String)LOG_TAG, (String)String.format("Running test %s on %s", test.getPackageName(), this.getDevice().getSerialNumber()));
            if (this.mSendCoverage && test.getCoverageTarget() != null) {
                this.sendCoverage(test.getPackageName(), test.getCoverageTarget(), listener);
            }
            test.setDevice(this.getDevice());
            test.run(listener);
            this.mTests.remove(0);
        }
    }

    private void sendCoverage(String packageName, String coverageTarget, ITestInvocationListener listener) {
        HashMap<String, String> coverageMetric = new HashMap<String, String>(1);
        coverageMetric.put(COVERAGE_TARGET_KEY, coverageTarget);
        listener.testRunStarted(packageName, 0);
        listener.testRunEnded(0L, coverageMetric);
    }

    private Collection<File> getRemoteFile(Collection<String> remoteFilePaths) throws DeviceNotAvailableException {
        ArrayList<File> files = new ArrayList<File>();
        if (this.getDevice() == null) {
            Log.d((String)LOG_TAG, (String)"Device not set, skipping collection of remote file");
            return files;
        }
        for (String remoteFilePath : remoteFilePaths) {
            try {
                File tmpFile = FileUtil.createTempFile("test_defs_", ".xml");
                this.getDevice().pullFile(remoteFilePath, tmpFile);
                files.add(tmpFile);
            }
            catch (IOException e) {
                Log.e((String)LOG_TAG, (String)"Failed to create temp file");
                Log.e((String)LOG_TAG, (Throwable)e);
            }
        }
        return files;
    }

    int getTestTimeout() {
        return this.mTestTimeout;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    XmlDefsParser createParser() {
        return new XmlDefsParser();
    }

    InstrumentationTest createInstrumentationTest() {
        return new InstrumentationTest();
    }

    @Override
    public boolean isResumable() {
        if (this.mTests == null) {
            return false;
        }
        return this.mIsResumeMode;
    }

    @Override
    public Collection<IRemoteTest> split() {
        XmlDefsTest shard;
        if (this.mLocalFiles.isEmpty()) {
            Log.w((String)LOG_TAG, (String)"sharding is only supported if local xml files have been specified");
            return null;
        }
        if (this.mNumShards <= 1) {
            return null;
        }
        try {
            this.buildTests();
        }
        catch (DeviceNotAvailableException e) {
            // empty catch block
        }
        if (this.mTests.size() <= 1) {
            Log.w((String)LOG_TAG, (String)"no tests to shard!");
            return null;
        }
        LinkedList<IRemoteTest> shardQueue = new LinkedList<IRemoteTest>();
        for (int i = 0; i < this.mNumShards && i < this.mTests.size(); ++i) {
            shard = new XmlDefsTest();
            shard.mTests = new LinkedList<InstrumentationTest>();
            shardQueue.add(shard);
        }
        while (!this.mTests.isEmpty()) {
            InstrumentationTest test = this.mTests.remove(0);
            shard = (XmlDefsTest)shardQueue.poll();
            shard.mTests.add(test);
            shardQueue.add(shard);
        }
        return shardQueue;
    }
}

