/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.util.IEmail;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email
implements IEmail {
    private static final String LOG_TAG = "Email";
    private static final String mailer = "/usr/bin/mailx";

    private static String join(Collection<String> list, String sep) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            String element = iter.next();
            builder.append(element);
            if (!iter.hasNext()) continue;
            builder.append(sep);
        }
        return builder.toString();
    }

    Process run(String[] cmd) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        return pb.start();
    }

    @Override
    public void send(IEmail.Message msg) throws IllegalArgumentException, IOException {
        int retValue;
        if (msg.getTo() == null || msg.getSubject() == null || msg.getBody() == null) {
            throw new IllegalArgumentException("Message has no destination or no subject");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(mailer);
        if (msg.getBcc() != null) {
            cmd.add("-b");
            cmd.add(Email.join(msg.getBcc(), ","));
        }
        if (msg.isHtml()) {
            cmd.add("-a");
            cmd.add("Content-type: text/html;");
        }
        if (msg.getCc() != null) {
            cmd.add("-c");
            cmd.add(Email.join(msg.getCc(), ","));
        }
        cmd.add("-s");
        cmd.add(msg.getSubject());
        cmd.addAll(msg.getTo());
        if (msg.getSender() != null) {
            cmd.add("-a");
            cmd.add(String.format("From: %s", msg.getSender()));
            cmd.add("--");
            cmd.add("-f");
            cmd.add(msg.getSender());
        }
        Log.i((String)LOG_TAG, (String)String.format("About to send email with command: %s", cmd));
        String[] strArray = new String[cmd.size()];
        Process mailerProc = this.run(cmd.toArray(strArray));
        BufferedOutputStream mailerStdin = new BufferedOutputStream(mailerProc.getOutputStream());
        mailerStdin.write(msg.getBody().getBytes("UTF-8"));
        mailerStdin.flush();
        mailerStdin.close();
        try {
            retValue = mailerProc.waitFor();
        }
        catch (InterruptedException e) {
            retValue = -12345;
        }
        if (retValue != 0) {
            int theByte;
            Log.e((String)LOG_TAG, (String)String.format("Mailer finished with non-zero return value: %d", retValue));
            BufferedInputStream mailerStdout = new BufferedInputStream(mailerProc.getInputStream());
            StringBuilder stdout = new StringBuilder();
            while ((theByte = mailerStdout.read()) != -1) {
                stdout.append((char)theByte);
            }
            Log.e((String)LOG_TAG, (String)("Mailer output was: " + stdout.toString()));
        } else {
            Log.v((String)LOG_TAG, (String)"Mailer returned successfully.");
        }
    }
}

