/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeTestsZipFolder {
    private Map<String, ItemType> mItems;
    private File mBase;
    private File mData;

    public FakeTestsZipFolder(Map<String, ItemType> items) {
        this.mItems = items;
    }

    public boolean createItems() throws IOException {
        this.mBase = File.createTempFile("tf_", "_test_zip");
        this.mBase.delete();
        this.mData = new File(this.mBase, "DATA");
        if (!this.mData.mkdirs()) {
            return false;
        }
        boolean failed = false;
        for (String fileName : this.mItems.keySet()) {
            File file = new File(this.mData, fileName);
            ItemType type = this.mItems.get(fileName);
            if (ItemType.DIRECTORY.equals((Object)type)) {
                if (file.mkdirs()) continue;
                failed = true;
                break;
            }
            File p = file.getParentFile();
            if (!p.exists() && !p.mkdirs()) {
                failed = true;
                break;
            }
            if (file.createNewFile()) continue;
            failed = true;
            break;
        }
        if (failed) {
            this.cleanUp();
        }
        return !failed;
    }

    public void cleanUp() {
        FileUtil.recursiveDelete(this.mBase);
    }

    protected File getDataFolder() {
        return this.mData;
    }

    public File getBasePath() {
        return this.mBase;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ItemType {
        FILE,
        DIRECTORY;

    }
}

