/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMap<K, V> {
    private final Map<K, List<V>> mInternalMap = new HashMap<K, List<V>>();

    public void clear() {
        this.mInternalMap.clear();
    }

    public boolean containsKey(K key) {
        return this.mInternalMap.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (List<V> valueList : this.mInternalMap.values()) {
            if (!valueList.contains(value)) continue;
            return true;
        }
        return false;
    }

    public List<V> get(K key) {
        return this.mInternalMap.get(key);
    }

    public boolean isEmpty() {
        return this.mInternalMap.isEmpty();
    }

    public Set<K> keySet() {
        return this.mInternalMap.keySet();
    }

    public V put(K key, V value) {
        List<V> valueList = this.mInternalMap.get(key);
        if (valueList == null) {
            valueList = new LinkedList<V>();
            this.mInternalMap.put(key, valueList);
        }
        valueList.add(value);
        return value;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(MultiMap<K, ? extends V> m) {
        for (K key : m.keySet()) {
            for (V value : m.get(key)) {
                this.put(key, value);
            }
        }
    }

    public List<V> remove(K key) {
        return this.mInternalMap.remove(key);
    }

    public int size() {
        return this.mInternalMap.size();
    }

    public List<V> values() {
        LinkedList<V> allValues = new LinkedList<V>();
        for (List<V> valueList : this.mInternalMap.values()) {
            allValues.addAll(valueList);
        }
        return allValues;
    }

    public Map<String, V> getUniqueMap() {
        HashMap uniqueMap = new HashMap();
        for (Map.Entry<K, List<V>> entry : this.mInternalMap.entrySet()) {
            int count = 1;
            for (V value : entry.getValue()) {
                if (count == 1) {
                    this.addUniqueEntry(uniqueMap, entry.getKey().toString(), value);
                } else {
                    this.addUniqueEntry(uniqueMap, String.format("%s%d", entry.getKey(), count), value);
                }
                ++count;
            }
        }
        return uniqueMap;
    }

    private String addUniqueEntry(Map<String, V> uniqueMap, String proposedKey, V value) {
        if (uniqueMap.containsKey(proposedKey)) {
            return this.addUniqueEntry(uniqueMap, String.format("%s%s", proposedKey, "X"), value);
        }
        uniqueMap.put(proposedKey, value);
        return proposedKey;
    }

    public int hashCode() {
        return ((Object)this.mInternalMap).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiMap other = (MultiMap)obj;
        return Objects.equal(this.mInternalMap, other.mInternalMap);
    }
}

