/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunUtil
implements IRunUtil {
    private static final int POLL_TIME_INCREASE_FACTOR = 4;
    private static IRunUtil sDefaultInstance = null;
    private File mWorkingDir = null;
    private Map<String, String> mEnvVariables = new HashMap<String, String>();

    public static IRunUtil getDefault() {
        if (sDefaultInstance == null) {
            sDefaultInstance = new RunUtil();
        }
        return sDefaultInstance;
    }

    @Override
    public synchronized void setWorkingDir(File dir) {
        this.mWorkingDir = dir;
    }

    @Override
    public synchronized void setEnvVariable(String name, String value) {
        this.mEnvVariables.put(name, value);
    }

    @Override
    public CommandResult runTimedCmd(long timeout, String ... command) {
        CommandResult result = new CommandResult();
        RunnableResult osRunnable = new RunnableResult(result, null, this.createProcessBuilder(command));
        CommandStatus status = this.runTimed(timeout, osRunnable, true);
        result.setStatus(status);
        return result;
    }

    private synchronized ProcessBuilder createProcessBuilder(String ... command) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (this.mWorkingDir != null) {
            processBuilder.directory(this.mWorkingDir);
        }
        if (!this.mEnvVariables.isEmpty()) {
            processBuilder.environment().putAll(this.mEnvVariables);
        }
        return processBuilder.command(command);
    }

    private synchronized ProcessBuilder createProcessBuilder(List<String> commandList) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (this.mWorkingDir != null) {
            processBuilder.directory(this.mWorkingDir);
        }
        if (!this.mEnvVariables.isEmpty()) {
            processBuilder.environment().putAll(this.mEnvVariables);
        }
        return processBuilder.command(commandList);
    }

    @Override
    public CommandResult runTimedCmdWithInput(long timeout, String input, String ... command) {
        CommandResult result = new CommandResult();
        RunnableResult osRunnable = new RunnableResult(result, input, this.createProcessBuilder(command));
        CommandStatus status = this.runTimed(timeout, osRunnable, true);
        result.setStatus(status);
        return result;
    }

    @Override
    public CommandResult runTimedCmdSilently(long timeout, String ... command) {
        CommandResult result = new CommandResult();
        RunnableResult osRunnable = new RunnableResult(result, null, this.createProcessBuilder(command));
        CommandStatus status = this.runTimed(timeout, osRunnable, false);
        result.setStatus(status);
        return result;
    }

    @Override
    public Process runCmdInBackground(String ... command) throws IOException {
        String fullCmd = Arrays.toString(command);
        LogUtil.CLog.v("Running %s", fullCmd);
        return this.createProcessBuilder(command).start();
    }

    @Override
    public Process runCmdInBackground(List<String> command) throws IOException {
        LogUtil.CLog.v("Running %s", command);
        return this.createProcessBuilder(command).start();
    }

    @Override
    public CommandStatus runTimed(long timeout, IRunUtil.IRunnableResult runnable, boolean logErrors) {
        RunnableNotifier runThread = new RunnableNotifier(runnable, logErrors);
        runThread.start();
        try {
            runThread.join(timeout);
        }
        catch (InterruptedException e) {
            LogUtil.CLog.i("runnable interrupted");
        }
        if (runThread.getStatus() == CommandStatus.TIMED_OUT || runThread.getStatus() == CommandStatus.EXCEPTION) {
            runThread.interrupt();
        }
        return runThread.getStatus();
    }

    @Override
    public boolean runTimedRetry(long opTimeout, long pollInterval, int attempts, IRunUtil.IRunnableResult runnable) {
        for (int i = 0; i < attempts; ++i) {
            if (this.runTimed(opTimeout, runnable, true) == CommandStatus.SUCCESS) {
                return true;
            }
            LogUtil.CLog.d("operation failed, waiting for %d ms", pollInterval);
            this.sleep(pollInterval);
        }
        return false;
    }

    @Override
    public boolean runFixedTimedRetry(long opTimeout, long pollInterval, long maxTime, IRunUtil.IRunnableResult runnable) {
        long initialTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < initialTime + maxTime) {
            if (this.runTimed(opTimeout, runnable, true) == CommandStatus.SUCCESS) {
                return true;
            }
            LogUtil.CLog.d("operation failed, waiting for %d ms", pollInterval);
            this.sleep(pollInterval);
        }
        return false;
    }

    @Override
    public boolean runEscalatingTimedRetry(long opTimeout, long initialPollInterval, long maxPollInterval, long maxTime, IRunUtil.IRunnableResult runnable) {
        long pollInterval = initialPollInterval;
        long initialTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < initialTime + maxTime) {
            if (this.runTimed(opTimeout, runnable, true) == CommandStatus.SUCCESS) {
                return true;
            }
            LogUtil.CLog.d("operation failed, waiting for %d ms", pollInterval);
            this.sleep(pollInterval);
            if ((pollInterval *= 4L) <= maxPollInterval) continue;
            pollInterval = maxPollInterval;
        }
        return false;
    }

    @Override
    public void sleep(long time) {
        if (time <= 0L) {
            return;
        }
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LogUtil.CLog.d("sleep interrupted");
        }
    }

    private class RunnableResult
    implements IRunUtil.IRunnableResult {
        private final ProcessBuilder mProcessBuilder;
        private final CommandResult mCommandResult;
        private final String mInput;
        private Process mProcess = null;

        RunnableResult(CommandResult result, String input, ProcessBuilder processBuilder) {
            this.mProcessBuilder = processBuilder;
            this.mInput = input;
            this.mCommandResult = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean run() throws Exception {
            LogUtil.CLog.d("Running %s", this.mProcessBuilder.command());
            this.mProcess = this.mProcessBuilder.start();
            if (this.mInput != null) {
                BufferedOutputStream processStdin = new BufferedOutputStream(this.mProcess.getOutputStream());
                processStdin.write(this.mInput.getBytes("UTF-8"));
                processStdin.flush();
                processStdin.close();
            }
            int rc = this.mProcess.waitFor();
            RunnableResult runnableResult = this;
            synchronized (runnableResult) {
                if (this.mProcess != null) {
                    this.mCommandResult.setStdout(StreamUtil.getStringFromStream(this.mProcess.getInputStream()));
                    this.mCommandResult.setStderr(StreamUtil.getStringFromStream(this.mProcess.getErrorStream()));
                }
            }
            if (rc == 0) {
                return true;
            }
            LogUtil.CLog.i("%s command failed. return code %d", this.mProcessBuilder.command(), rc);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            if (this.mProcess != null) {
                RunnableResult runnableResult = this;
                synchronized (runnableResult) {
                    this.mProcess.destroy();
                    this.mProcess = null;
                }
            }
        }
    }

    private static class RunnableNotifier
    extends Thread {
        private final IRunUtil.IRunnableResult mRunnable;
        private CommandStatus mStatus = CommandStatus.TIMED_OUT;
        private boolean mLogErrors = true;

        RunnableNotifier(IRunUtil.IRunnableResult runnable, boolean logErrors) {
            this.mRunnable = runnable;
            this.mLogErrors = logErrors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CommandStatus status;
            try {
                status = this.mRunnable.run() ? CommandStatus.SUCCESS : CommandStatus.FAILED;
            }
            catch (InterruptedException e) {
                LogUtil.CLog.i("runutil interrupted");
                status = CommandStatus.EXCEPTION;
            }
            catch (Exception e) {
                if (this.mLogErrors) {
                    LogUtil.CLog.e("Exception occurred when executing runnable");
                    LogUtil.CLog.e(e);
                }
                status = CommandStatus.EXCEPTION;
            }
            RunnableNotifier runnableNotifier = this;
            synchronized (runnableNotifier) {
                this.mStatus = status;
            }
        }

        public void interrupt() {
            this.mRunnable.cancel();
            super.interrupt();
        }

        synchronized CommandStatus getStatus() {
            return this.mStatus;
        }
    }
}

