/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFormatter {
    private int mColumnSpacing = 2;

    public TableFormatter setColumnSpacing(int spacing) {
        this.mColumnSpacing = spacing;
        return this;
    }

    public void displayTable(List<List<String>> table, PrintWriter writer) {
        if (table.size() <= 0) {
            throw new IllegalArgumentException();
        }
        List<Integer> maxColumnSizes = this.getColumnSizes(table);
        for (List<String> rowData : table) {
            for (int col = 0; col < rowData.size(); ++col) {
                writer.append(rowData.get(col));
                int numPaddingChars = maxColumnSizes.get(col) - rowData.get(col).length();
                this.insertPadding(numPaddingChars, writer);
            }
            writer.println();
        }
    }

    private void insertPadding(int numChars, PrintWriter writer) {
        for (int i = 0; i < numChars; ++i) {
            writer.append(' ');
        }
    }

    private List<Integer> getColumnSizes(List<List<String>> table) {
        ArrayList<Integer> maxColumnSizes = new ArrayList<Integer>();
        for (List<String> rowData : table) {
            for (int colIndex = 0; colIndex < rowData.size(); ++colIndex) {
                if (colIndex >= maxColumnSizes.size()) {
                    maxColumnSizes.add(colIndex, 0);
                }
                int stringSize = rowData.get(colIndex).length() + this.mColumnSpacing;
                if ((Integer)maxColumnSizes.get(colIndex) >= stringSize) continue;
                maxColumnSizes.set(colIndex, stringSize);
            }
        }
        return maxColumnSizes;
    }
}

