/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.util.ClassPathScanner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLoader {
    private static final String LOG_TAG = "TestLoader";

    public Test loadTests(File testJarFile, Collection<File> dependentJars) {
        ClassPathScanner scanner = new ClassPathScanner();
        try {
            Set<String> classNames = scanner.getEntriesFromJar(testJarFile, new ClassPathScanner.ExternalClassNameFilter());
            ClassLoader jarClassLoader = this.buildJarClassLoader(testJarFile, dependentJars);
            return this.loadTests(classNames, jarClassLoader);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)String.format("IOException when loading test classes from jar %s", testJarFile.getAbsolutePath()));
            Log.e((String)LOG_TAG, (Throwable)e);
            return null;
        }
    }

    private ClassLoader buildJarClassLoader(File jarFile, Collection<File> dependentJars) throws MalformedURLException {
        URL[] urls = new URL[dependentJars.size() + 1];
        urls[0] = jarFile.toURI().toURL();
        Iterator<File> jarIter = dependentJars.iterator();
        for (int i = 1; i <= dependentJars.size(); ++i) {
            urls[i] = jarIter.next().toURI().toURL();
        }
        return new URLClassLoader(urls);
    }

    private Test loadTests(Set<String> classNames, ClassLoader classLoader) {
        TestSuite testSuite = new TestSuite();
        for (String className : classNames) {
            try {
                Class<?> testClass = Class.forName(className, true, classLoader);
                if (!TestCase.class.isAssignableFrom(testClass)) continue;
                testSuite.addTestSuite(testClass);
            }
            catch (ClassNotFoundException e) {
            }
            catch (RuntimeException e) {
                Log.e((String)LOG_TAG, (Throwable)e);
            }
        }
        return testSuite;
    }
}

