/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.RegexTrie;
import com.android.tradefed.util.brillopad.IParser;
import com.android.tradefed.util.brillopad.NoopParser;
import com.android.tradefed.util.brillopad.item.IItem;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractSectionParser
implements IParser {
    private RegexTrie<IParser> mSectionTrie = new RegexTrie();
    private IParser mCurrentParser = new NoopParser();
    private List<String> mParseBlock = new LinkedList<String>();
    private Map<String, IItem> mSections = new HashMap<String, IItem>();

    protected void addSectionParser(IParser parser, String pattern) {
        if (parser == null) {
            throw new NullPointerException("Parser is null");
        }
        if (pattern == null) {
            throw new NullPointerException("Pattern is null");
        }
        this.mSectionTrie.put(parser, pattern);
    }

    protected void parseLine(String line) {
        IParser nextParser = this.mSectionTrie.retrieve(line);
        if (nextParser == null) {
            if (this.mCurrentParser != null) {
                this.mParseBlock.add(line);
            } else {
                LogUtil.CLog.w("Line outside of parsed section: %s", line);
            }
        } else {
            this.runCurrentParser();
            this.mParseBlock.clear();
            this.mCurrentParser = nextParser;
            this.onSwitchParser();
        }
    }

    protected void commit() {
        this.runCurrentParser();
    }

    protected IItem getSection(String section) {
        return this.mSections.get(section);
    }

    protected void setParser(IParser parser) {
        this.mCurrentParser = parser;
    }

    protected void onSwitchParser() {
    }

    private void runCurrentParser() {
        IItem item;
        if (this.mCurrentParser != null && (item = this.mCurrentParser.parse(this.mParseBlock)) != null && !(this.mCurrentParser instanceof NoopParser)) {
            this.mSections.put(item.getType(), item);
            LogUtil.CLog.v("Just ran the %s parser", this.mCurrentParser.getClass().getSimpleName());
        }
    }
}

