/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.brillopad.AnrParser;
import com.android.tradefed.util.brillopad.IParser;
import com.android.tradefed.util.brillopad.JavaCrashParser;
import com.android.tradefed.util.brillopad.NativeCrashParser;
import com.android.tradefed.util.brillopad.item.GenericLogcatItem;
import com.android.tradefed.util.brillopad.item.IItem;
import com.android.tradefed.util.brillopad.item.LogcatItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogcatParser
implements IParser {
    private static final Pattern THREADTIME_LINE = Pattern.compile("^(\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3})\\s+(\\d+)\\s+(\\d+)\\s+([A-Z])\\s+(.+?)\\s*: (.*)$");
    private static final Pattern TIME_LINE = Pattern.compile("^(\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3})\\s+(\\w)/(.+?)\\(\\s*(\\d+)\\): (.*)$");
    private static final int MAX_BUFF_SIZE = 500;
    private static final int MAX_LAST_PREAMBLE_SIZE = 15;
    private static final int MAX_PROC_PREAMBLE_SIZE = 15;
    private LinkedList<String> mRingBuffer = new LinkedList();
    private String mYear = null;
    LogcatItem mLogcat = new LogcatItem();
    Map<String, LogcatData> mDataMap = new HashMap<String, LogcatData>();
    List<LogcatData> mDataList = new LinkedList<LogcatData>();
    private Date mStartTime = null;
    private Date mStopTime = null;

    public LogcatParser() {
    }

    public LogcatParser(String year) {
        this.setYear(year);
    }

    public void setYear(String year) {
        this.mYear = year;
    }

    public LogcatItem parse(BufferedReader input) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            this.parseLine(line);
        }
        this.commit();
        return this.mLogcat;
    }

    public LogcatItem parse(InputStreamSource input) throws IOException {
        InputStream stream = input.createInputStream();
        return this.parse(new BufferedReader(new InputStreamReader(stream)));
    }

    @Override
    public LogcatItem parse(List<String> lines) {
        for (String line : lines) {
            this.parseLine(line);
        }
        this.commit();
        return this.mLogcat;
    }

    private void parseLine(String line) {
        LogcatData data;
        String key;
        Integer pid = null;
        Integer tid = null;
        Date time = null;
        String level = null;
        String tag = null;
        String msg = null;
        Matcher m = THREADTIME_LINE.matcher(line);
        Matcher tm = TIME_LINE.matcher(line);
        if (m.matches()) {
            time = this.parseTime(m.group(1));
            pid = Integer.parseInt(m.group(2));
            tid = Integer.parseInt(m.group(3));
            level = m.group(4);
            tag = m.group(5);
            msg = m.group(6);
        } else if (tm.matches()) {
            time = this.parseTime(tm.group(1));
            level = tm.group(2);
            tag = tm.group(3);
            pid = Integer.parseInt(tm.group(4));
            msg = tm.group(5);
        } else {
            LogUtil.CLog.w("Failed to parse line '%s'", line);
            return;
        }
        if (this.mStartTime == null) {
            this.mStartTime = time;
        }
        this.mStopTime = time;
        if ("E".equals(level) && "ActivityManager".equals(tag)) {
            key = LogcatParser.encodeLine(pid, tid, level, tag);
            if (!this.mDataMap.containsKey(key) || AnrParser.START.matcher(msg).matches()) {
                data = new LogcatData(pid, tid, time, level, tag, this.getLastPreamble(), this.getProcPreamble(pid));
                this.mDataMap.put(key, data);
                this.mDataList.add(data);
            } else {
                data = this.mDataMap.get(key);
            }
            data.mLines.add(msg);
        }
        if ("E".equals(level) && "AndroidRuntime".equals(tag) || "I".equals(level) && "DEBUG".equals(tag)) {
            key = LogcatParser.encodeLine(pid, tid, level, tag);
            if (!this.mDataMap.containsKey(key)) {
                data = new LogcatData(pid, tid, time, level, tag, this.getLastPreamble(), this.getProcPreamble(pid));
                this.mDataMap.put(key, data);
                this.mDataList.add(data);
            } else {
                data = this.mDataMap.get(key);
            }
            data.mLines.add(msg);
        }
        this.mRingBuffer.add(line);
        if (this.mRingBuffer.size() > 500) {
            this.mRingBuffer.removeFirst();
        }
    }

    private void commit() {
        for (LogcatData data : this.mDataList) {
            IItem item = null;
            if ("E".equals(data.mLevel) && "ActivityManager".equals(data.mTag)) {
                LogUtil.CLog.v("Parsing ANR: %s", data.mLines);
                item = new AnrParser().parse((List)data.mLines);
            } else if ("E".equals(data.mLevel) && "AndroidRuntime".equals(data.mTag)) {
                LogUtil.CLog.v("Parsing Java crash: %s", data.mLines);
                item = new JavaCrashParser().parse((List)data.mLines);
            } else if ("I".equals(data.mLevel) && "DEBUG".equals(data.mTag)) {
                LogUtil.CLog.v("Parsing native crash: %s", data.mLines);
                item = new NativeCrashParser().parse((List)data.mLines);
            }
            if (item == null) continue;
            ((GenericLogcatItem)item).setEventTime(data.mTime);
            ((GenericLogcatItem)item).setPid(data.mPid);
            ((GenericLogcatItem)item).setTid(data.mTid);
            ((GenericLogcatItem)item).setLastPreamble(data.mLastPreamble);
            ((GenericLogcatItem)item).setProcessPreamble(data.mProcPreamble);
            this.mLogcat.addEvent(item);
        }
        this.mLogcat.setStartTime(this.mStartTime);
        this.mLogcat.setStopTime(this.mStopTime);
    }

    private static String encodeLine(Integer pid, Integer tid, String level, String tag) {
        if (tid == null) {
            return String.format("%d|%s|%s", pid, level, tag);
        }
        return String.format("%d|%d|%s|%s", pid, tid, level, tag);
    }

    private Date parseTime(String timeStr) {
        if (this.mYear == null) {
            SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
            this.mYear = yearFormatter.format(new Date());
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            return formatter.parse(String.format("%s-%s", this.mYear, timeStr));
        }
        catch (ParseException e) {
            LogUtil.CLog.e("Could not parse time string %s", timeStr);
            return null;
        }
    }

    private String getLastPreamble() {
        int size = this.mRingBuffer.size();
        List<String> preamble = size > this.getLastPreambleSize() ? this.mRingBuffer.subList(size - this.getLastPreambleSize(), size) : this.mRingBuffer;
        return ArrayUtil.join("\n", preamble).trim();
    }

    private String getProcPreamble(int pid) {
        LinkedList<String> preamble = new LinkedList<String>();
        ListIterator<String> li = this.mRingBuffer.listIterator(this.mRingBuffer.size());
        while (li.hasPrevious()) {
            String line = li.previous();
            Matcher m = THREADTIME_LINE.matcher(line);
            Matcher tm = TIME_LINE.matcher(line);
            if (m.matches() && pid == Integer.parseInt(m.group(2)) || tm.matches() && pid == Integer.parseInt(tm.group(4))) {
                preamble.addFirst(line);
            }
            if (preamble.size() != this.getProcPreambleSize()) continue;
            return ArrayUtil.join("\n", preamble).trim();
        }
        return ArrayUtil.join("\n", preamble).trim();
    }

    int getLastPreambleSize() {
        return 15;
    }

    int getProcPreambleSize() {
        return 15;
    }

    private class LogcatData {
        public Integer mPid = null;
        public Integer mTid = null;
        public Date mTime = null;
        public String mLevel = null;
        public String mTag = null;
        public String mLastPreamble = null;
        public String mProcPreamble = null;
        public List<String> mLines = new LinkedList<String>();

        public LogcatData(Integer pid, Integer tid, Date time, String level, String tag, String lastPreamble, String procPreamble) {
            this.mPid = pid;
            this.mTid = tid;
            this.mTime = time;
            this.mLevel = level;
            this.mTag = tag;
            this.mLastPreamble = lastPreamble;
            this.mProcPreamble = procPreamble;
        }
    }
}

