/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.brillopad.IParser;
import com.android.tradefed.util.brillopad.item.ProcrankItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcrankParser
implements IParser {
    private static final Pattern NUMBER_PAT = Pattern.compile("(\\d+)([BKMGbkmg])?");
    private static final Pattern END_PAT = Pattern.compile("^\\s+-{6}\\s+-{6}\\s+-{6}");
    private int mNumFields = -1;
    private String[] mFieldNames = null;

    private static Integer parseMem(String val) {
        Integer count = null;
        Matcher m = NUMBER_PAT.matcher(val);
        if (m.matches()) {
            count = Integer.parseInt(m.group(1));
            String suffix = m.group(2);
            if (suffix == null) {
                return count;
            }
            if ("b".equals(suffix = suffix.toLowerCase())) {
                count = count / 1024;
            } else if (!"k".equals(suffix)) {
                if ("m".equals(suffix)) {
                    count = count * 1024;
                } else if ("g".equals(suffix)) {
                    count = count * 0x100000;
                }
            }
        }
        return count;
    }

    @Override
    public ProcrankItem parse(List<String> lines) {
        String line;
        Matcher endMatcher;
        ProcrankItem item = new ProcrankItem();
        Iterator<String> i$ = lines.iterator();
        while (i$.hasNext() && !(endMatcher = END_PAT.matcher(line = i$.next())).matches()) {
            line = line.replaceFirst("^\\s+", "");
            if (this.mFieldNames == null) {
                this.mFieldNames = line.split("\\s+");
                this.mNumFields = this.mFieldNames.length;
                continue;
            }
            String[] fields = line.split("\\s+", this.mNumFields);
            if (fields.length != this.mNumFields) {
                LogUtil.CLog.w("Skipping line which contains invalid format: %s", line);
                continue;
            }
            String cmdline = fields[fields.length - 1];
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            boolean validLine = true;
            for (int i = 0; i < this.mNumFields - 1 && i < fields.length; ++i) {
                Integer value = ProcrankParser.parseMem(fields[i]);
                if (value == null) {
                    validLine = false;
                    break;
                }
                valueMap.put(this.mFieldNames[i], value);
            }
            if (!validLine) {
                LogUtil.CLog.w("Skipping line which contains invalid format: %s", line);
                continue;
            }
            item.put(cmdline, valueMap);
        }
        return item;
    }
}

