/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.brillopad.IParser;
import com.android.tradefed.util.brillopad.item.SystemPropsItem;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPropsParser
implements IParser {
    private static final Pattern PROP_LINE = Pattern.compile("^\\[(.*)\\]: \\[(.*)\\]$");

    @Override
    public SystemPropsItem parse(List<String> lines) {
        SystemPropsItem item = new SystemPropsItem();
        for (String line : lines) {
            Matcher m = PROP_LINE.matcher(line);
            if (m.matches()) {
                item.put(m.group(1), m.group(2));
                continue;
            }
            LogUtil.CLog.w("Failed to parse line '%s'", line);
        }
        return item;
    }
}

