/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad.item;

import com.android.tradefed.util.brillopad.item.ConflictingItemException;
import com.android.tradefed.util.brillopad.item.IItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericItem
implements IItem {
    private Map<String, Object> mAttributes = new HashMap<String, Object>();
    private Set<String> mAllowedAttributes = new HashSet<String>();
    private String mType = null;

    protected GenericItem(String type, Set<String> allowedAttributes) {
        this.mAllowedAttributes.addAll(allowedAttributes);
        this.mType = type;
    }

    protected GenericItem(String type, Set<String> allowedAttributes, Map<String, Object> attributes) {
        this(type, allowedAttributes);
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getType() {
        return this.mType;
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        if (this == other) {
            return this;
        }
        if (other == null || this.getClass() != other.getClass()) {
            throw new ConflictingItemException("Conflicting class types");
        }
        return new GenericItem(this.getType(), this.mAllowedAttributes, this.mergeAttributes(other));
    }

    protected Map<String, Object> mergeAttributes(IItem other) throws ConflictingItemException {
        if (this == other) {
            return this.mAttributes;
        }
        if (other == null || this.getClass() != other.getClass()) {
            throw new ConflictingItemException("Conflicting class types");
        }
        GenericItem item = (GenericItem)other;
        HashMap<String, Object> mergedAttributes = new HashMap<String, Object>();
        for (String attribute : this.mAllowedAttributes) {
            mergedAttributes.put(attribute, GenericItem.mergeObjects(this.getAttribute(attribute), item.getAttribute(attribute)));
        }
        return mergedAttributes;
    }

    @Override
    public boolean isConsistent(IItem other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GenericItem item = (GenericItem)other;
        for (String attribute : this.mAllowedAttributes) {
            if (GenericItem.areConsistent(this.getAttribute(attribute), item.getAttribute(attribute))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GenericItem item = (GenericItem)other;
        for (String attribute : this.mAllowedAttributes) {
            if (GenericItem.areEqual(this.getAttribute(attribute), item.getAttribute(attribute))) continue;
            return false;
        }
        return true;
    }

    protected void setAttribute(String attribute, Object value) throws IllegalArgumentException {
        if (!this.mAllowedAttributes.contains(attribute)) {
            throw new IllegalArgumentException();
        }
        this.mAttributes.put(attribute, value);
    }

    protected Object getAttribute(String attribute) throws IllegalArgumentException {
        if (!this.mAllowedAttributes.contains(attribute)) {
            throw new IllegalArgumentException();
        }
        return this.mAttributes.get(attribute);
    }

    protected static boolean areEqual(Object object1, Object object2) {
        return object1 == null ? object2 == null : object1.equals(object2);
    }

    protected static boolean areConsistent(Object object1, Object object2) {
        return object1 == null || object2 == null ? true : object1.equals(object2);
    }

    protected static Object mergeObjects(Object object1, Object object2) throws ConflictingItemException {
        if (!GenericItem.areConsistent(object1, object2)) {
            throw new ConflictingItemException(String.format("%s conflicts with %s", object1, object2));
        }
        return object1 == null ? object2 : object1;
    }
}

