/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad.item;

import com.android.tradefed.util.brillopad.item.AnrItem;
import com.android.tradefed.util.brillopad.item.GenericItem;
import com.android.tradefed.util.brillopad.item.IItem;
import com.android.tradefed.util.brillopad.item.JavaCrashItem;
import com.android.tradefed.util.brillopad.item.NativeCrashItem;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogcatItem
extends GenericItem {
    public static final String TYPE = "LOGCAT";
    private static final String START_TIME = "START_TIME";
    private static final String STOP_TIME = "STOP_TIME";
    private static final String EVENTS = "EVENTS";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("START_TIME", "STOP_TIME", "EVENTS"));

    public LogcatItem() {
        super(TYPE, ATTRIBUTES);
        this.setAttribute(EVENTS, new ItemList());
    }

    public Date getStartTime() {
        return (Date)this.getAttribute(START_TIME);
    }

    public void setStartTime(Date time) {
        this.setAttribute(START_TIME, time);
    }

    public Date getStopTime() {
        return (Date)this.getAttribute(STOP_TIME);
    }

    public void setStopTime(Date time) {
        this.setAttribute(STOP_TIME, time);
    }

    public List<IItem> getEvents() {
        return (ItemList)this.getAttribute(EVENTS);
    }

    public void addEvent(IItem event) {
        ((ItemList)this.getAttribute(EVENTS)).add(event);
    }

    public List<AnrItem> getAnrs() {
        LinkedList<AnrItem> anrs = new LinkedList<AnrItem>();
        for (IItem item : this.getEvents()) {
            if (!(item instanceof AnrItem)) continue;
            anrs.add((AnrItem)item);
        }
        return anrs;
    }

    public List<JavaCrashItem> getJavaCrashes() {
        LinkedList<JavaCrashItem> jcs = new LinkedList<JavaCrashItem>();
        for (IItem item : this.getEvents()) {
            if (!(item instanceof JavaCrashItem)) continue;
            jcs.add((JavaCrashItem)item);
        }
        return jcs;
    }

    public List<NativeCrashItem> getNativeCrashes() {
        LinkedList<NativeCrashItem> ncs = new LinkedList<NativeCrashItem>();
        for (IItem item : this.getEvents()) {
            if (!(item instanceof NativeCrashItem)) continue;
            ncs.add((NativeCrashItem)item);
        }
        return ncs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemList
    extends LinkedList<IItem> {
        private static final long serialVersionUID = 1088529764741812025L;

        private ItemList() {
        }
    }
}

