/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.net;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.net.IHttpHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHelper
implements IHttpHelper {
    private long mQueryTimeout = 60000L;
    private long mInitialPollInterval = 1000L;
    private long mMaxPollInterval = 600000L;
    private long mMaxTime = 600000L;

    @Override
    public String buildUrl(String baseUrl, MultiMap<String, String> paramMap) {
        StringBuilder urlBuilder = new StringBuilder(baseUrl);
        if (paramMap != null && !paramMap.isEmpty()) {
            urlBuilder.append("?");
            urlBuilder.append(this.buildParameters(paramMap));
        }
        return urlBuilder.toString();
    }

    @Override
    public String buildParameters(MultiMap<String, String> paramMap) {
        StringBuilder urlBuilder = new StringBuilder("");
        boolean first = true;
        for (String key : paramMap.keySet()) {
            for (String value : paramMap.get(key)) {
                if (!first) {
                    urlBuilder.append("&");
                } else {
                    first = false;
                }
                try {
                    urlBuilder.append(URLEncoder.encode(key, "UTF-8"));
                    urlBuilder.append("=");
                    urlBuilder.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return urlBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doGet(String url) throws IOException, IHttpHelper.DataSizeException {
        String string;
        LogUtil.CLog.d("Performing GET request for %s", url);
        InputStream remote = null;
        byte[] bufResult = new byte[65536];
        int currBufPos = 0;
        try {
            int bytesRead;
            remote = this.getRemoteUrlStream(new URL(url));
            while ((bytesRead = remote.read(bufResult, currBufPos, bufResult.length - currBufPos)) != -1) {
                if ((currBufPos += bytesRead) < bufResult.length) continue;
                throw new IHttpHelper.DataSizeException();
            }
            string = new String(bufResult, 0, currBufPos);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(remote);
            throw throwable;
        }
        StreamUtil.closeStream(remote);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGetIgnore(String url) throws IOException {
        LogUtil.CLog.d("Performing GET request for %s. Ignoring result.", url);
        InputStream remote = null;
        try {
            remote = this.getRemoteUrlStream(new URL(url));
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(remote);
            throw throwable;
        }
        StreamUtil.closeStream(remote);
    }

    @Override
    public HttpURLConnection createConnection(URL url, String method, String contentType) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }

    @Override
    public HttpURLConnection createXmlConnection(URL url, String method) throws IOException {
        return this.createConnection(url, method, "text/xml");
    }

    @Override
    public HttpURLConnection createJsonConnection(URL url, String method) throws IOException {
        return this.createConnection(url, method, "text/json");
    }

    @Override
    public String doGetWithRetry(String url) throws IOException, IHttpHelper.DataSizeException {
        GetRequestRunnable runnable = new GetRequestRunnable(url, false);
        if (this.getRunUtil().runEscalatingTimedRetry(this.getOpTimeout(), this.getInitialPollInterval(), this.getMaxPollInterval(), this.getMaxTime(), runnable)) {
            return runnable.getResponse();
        }
        if (runnable.getException() instanceof IOException) {
            throw (IOException)runnable.getException();
        }
        if (runnable.getException() instanceof IHttpHelper.DataSizeException) {
            throw (IHttpHelper.DataSizeException)runnable.getException();
        }
        if (runnable.getException() instanceof RuntimeException) {
            throw (RuntimeException)runnable.getException();
        }
        throw new IOException("GET request could not be completed");
    }

    @Override
    public void doGetIgnoreWithRetry(String url) throws IOException {
        GetRequestRunnable runnable = new GetRequestRunnable(url, true);
        if (this.getRunUtil().runEscalatingTimedRetry(this.getOpTimeout(), this.getInitialPollInterval(), this.getMaxPollInterval(), this.getMaxTime(), runnable)) {
            return;
        }
        if (runnable.getException() instanceof IOException) {
            throw (IOException)runnable.getException();
        }
        if (runnable.getException() instanceof RuntimeException) {
            throw (RuntimeException)runnable.getException();
        }
        throw new IOException("GET request could not be completed");
    }

    @Override
    public String doPostWithRetry(String url, String postData) throws IOException, IHttpHelper.DataSizeException {
        PostRequestRunnable runnable = new PostRequestRunnable(url, postData);
        if (this.getRunUtil().runEscalatingTimedRetry(this.getOpTimeout(), this.getInitialPollInterval(), this.getMaxPollInterval(), this.getMaxTime(), runnable)) {
            return runnable.getResponse();
        }
        if (runnable.getException() instanceof IOException) {
            throw (IOException)runnable.getException();
        }
        if (runnable.getException() instanceof IHttpHelper.DataSizeException) {
            throw (IHttpHelper.DataSizeException)runnable.getException();
        }
        if (runnable.getException() instanceof RuntimeException) {
            throw (RuntimeException)runnable.getException();
        }
        throw new IOException("POST request could not be completed");
    }

    InputStream getRemoteUrlStream(URL url) throws IOException {
        return url.openStream();
    }

    InputStream getConnectionInputStream(HttpURLConnection conn) throws IOException {
        return conn.getInputStream();
    }

    OutputStream getConnectionOutputStream(HttpURLConnection conn) throws IOException {
        return conn.getOutputStream();
    }

    @Override
    public long getOpTimeout() {
        return this.mQueryTimeout;
    }

    @Override
    public void setOpTimeout(long time) {
        this.mQueryTimeout = time;
    }

    @Override
    public long getInitialPollInterval() {
        return this.mInitialPollInterval;
    }

    @Override
    public void setInitialPollInterval(long time) {
        this.mInitialPollInterval = time;
    }

    @Override
    public long getMaxPollInterval() {
        return this.mMaxPollInterval;
    }

    @Override
    public void setMaxPollInterval(long time) {
        this.mMaxPollInterval = time;
    }

    @Override
    public long getMaxTime() {
        return this.mMaxTime;
    }

    @Override
    public void setMaxTime(long time) {
        this.mMaxTime = time;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    private class PostRequestRunnable
    extends RequestRunnable {
        String mPostData;

        public PostRequestRunnable(String url, String postData) {
            super(url);
            this.mPostData = postData;
        }

        /*
         * Exception decompiling
         */
        public boolean run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class GetRequestRunnable
    extends RequestRunnable {
        private boolean mIgnoreResult;

        public GetRequestRunnable(String url, boolean ignoreResult) {
            super(url);
            this.mIgnoreResult = ignoreResult;
        }

        public boolean run() {
            try {
                if (this.mIgnoreResult) {
                    HttpHelper.this.doGetIgnore(this.getUrl());
                } else {
                    this.setResponse(HttpHelper.this.doGet(this.getUrl()));
                }
                return true;
            }
            catch (IOException e) {
                LogUtil.CLog.i("IOException %s from %s", e.getMessage(), this.getUrl());
                this.setException(e);
            }
            catch (IHttpHelper.DataSizeException e) {
                LogUtil.CLog.i("Unexpected oversized response from %s", this.getUrl());
                this.setException(e);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.i("RuntimeException %s", e.getMessage());
                this.setException(e);
            }
            return false;
        }
    }

    private abstract class RequestRunnable
    implements IRunUtil.IRunnableResult {
        private String mResponse = null;
        private Exception mException = null;
        private final String mUrl;

        public RequestRunnable(String url) {
            this.mUrl = url;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public String getResponse() {
            return this.mResponse;
        }

        protected void setResponse(String response) {
            this.mResponse = response;
        }

        public Exception getException() {
            return this.mException;
        }

        protected void setException(Exception e) {
            this.mException = e;
        }

        public void cancel() {
        }
    }
}

