/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.xml;

import com.android.ddmlib.Log;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlParser {
    private static final String LOG_TAG = "XmlDefsParser";

    public void parse(InputStream xmlInput) throws ParseException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            DefaultHandler handler = this.createXmlHandler();
            parser.parse(new InputSource(xmlInput), handler);
        }
        catch (ParserConfigurationException e) {
            Log.e((String)LOG_TAG, (Throwable)e);
            throw new ParseException(e);
        }
        catch (SAXException e) {
            Log.e((String)LOG_TAG, (Throwable)e);
            throw new ParseException(e);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (Throwable)e);
            throw new ParseException(e);
        }
    }

    protected abstract DefaultHandler createXmlHandler();

    public static class ParseException
    extends Exception {
        public ParseException(Throwable cause) {
            super(cause);
        }
    }
}

