/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.xml;

import com.android.tradefed.log.LogUtil;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AndroidManifestWriter {
    private final Document mDoc;
    private final String mOsManifestFilePath;
    private static final String NODE_USES_SDK = "uses-sdk";
    private static final String ATTRIBUTE_MIN_SDK_VERSION = "minSdkVersion";
    private static final String NS_RESOURCES = "http://schemas.android.com/apk/res/android";

    private AndroidManifestWriter(Document doc, String osManifestFilePath) {
        this.mDoc = doc;
        this.mOsManifestFilePath = osManifestFilePath;
    }

    public boolean setMinSdkVersion(String minSdkVersion) {
        Element usesSdkElement = null;
        NodeList nodeList = this.mDoc.getElementsByTagName(NODE_USES_SDK);
        if (nodeList.getLength() > 0) {
            usesSdkElement = (Element)nodeList.item(0);
        } else {
            usesSdkElement = this.mDoc.createElement(NODE_USES_SDK);
            this.mDoc.getDocumentElement().appendChild(usesSdkElement);
        }
        Attr minSdkAttr = this.mDoc.createAttributeNS(NS_RESOURCES, ATTRIBUTE_MIN_SDK_VERSION);
        String prefix = this.mDoc.lookupPrefix(NS_RESOURCES);
        minSdkAttr.setPrefix(prefix);
        minSdkAttr.setValue(minSdkVersion);
        usesSdkElement.setAttributeNodeNS(minSdkAttr);
        return this.saveXmlToFile();
    }

    private boolean saveXmlToFile() {
        try {
            DOMSource source = new DOMSource(this.mDoc);
            File file = new File(this.mOsManifestFilePath);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            LogUtil.CLog.e("Failed to write xml file %s", this.mOsManifestFilePath);
            LogUtil.CLog.e(e);
            return false;
        }
        catch (TransformerException e) {
            LogUtil.CLog.e("Failed to write xml file %s", this.mOsManifestFilePath);
            LogUtil.CLog.e(e);
            return false;
        }
        return true;
    }

    public static AndroidManifestWriter parse(String osManifestFilePath) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(osManifestFilePath);
            return new AndroidManifestWriter(doc, osManifestFilePath);
        }
        catch (ParserConfigurationException e) {
            LogUtil.CLog.e("Error parsing file %s", osManifestFilePath);
            LogUtil.CLog.e(e);
            return null;
        }
        catch (SAXException e) {
            LogUtil.CLog.e("Error parsing file %s", osManifestFilePath);
            LogUtil.CLog.e(e);
            return null;
        }
        catch (IOException e) {
            LogUtil.CLog.e("Error parsing file %s", osManifestFilePath);
            LogUtil.CLog.e(e);
            return null;
        }
    }
}

