/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object object, @Nullable Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static int hashCode(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(Objects.simpleName(object.getClass()));
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(Objects.simpleName(clazz));
    }

    public static ToStringHelper toStringHelper(String string) {
        return new ToStringHelper(string);
    }

    private static String simpleName(Class<?> clazz) {
        String string = clazz.getName();
        int n = (string = string.replaceAll("\\$[0-9]+", "\\$")).lastIndexOf(36);
        if (n == -1) {
            n = string.lastIndexOf(46);
        }
        return string.substring(n + 1);
    }

    public static <T> T firstNonNull(@Nullable T t, @Nullable T t2) {
        return t != null ? t : Preconditions.checkNotNull(t2);
    }

    public static final class ToStringHelper {
        private final StringBuilder builder;
        private boolean needsSeparator = false;

        private ToStringHelper(String string) {
            Preconditions.checkNotNull(string);
            this.builder = new StringBuilder(32).append(string).append('{');
        }

        public ToStringHelper add(String string, @Nullable Object object) {
            this.checkNameAndAppend(string).append(object);
            return this;
        }

        public ToStringHelper add(String string, boolean bl) {
            this.checkNameAndAppend(string).append(bl);
            return this;
        }

        public ToStringHelper add(String string, char c) {
            this.checkNameAndAppend(string).append(c);
            return this;
        }

        public ToStringHelper add(String string, double d) {
            this.checkNameAndAppend(string).append(d);
            return this;
        }

        public ToStringHelper add(String string, float f) {
            this.checkNameAndAppend(string).append(f);
            return this;
        }

        public ToStringHelper add(String string, int n) {
            this.checkNameAndAppend(string).append(n);
            return this;
        }

        public ToStringHelper add(String string, long l) {
            this.checkNameAndAppend(string).append(l);
            return this;
        }

        private StringBuilder checkNameAndAppend(String string) {
            Preconditions.checkNotNull(string);
            return this.maybeAppendSeparator().append(string).append('=');
        }

        public ToStringHelper addValue(@Nullable Object object) {
            this.maybeAppendSeparator().append(object);
            return this;
        }

        public ToStringHelper addValue(boolean bl) {
            this.maybeAppendSeparator().append(bl);
            return this;
        }

        public ToStringHelper addValue(char c) {
            this.maybeAppendSeparator().append(c);
            return this;
        }

        public ToStringHelper addValue(double d) {
            this.maybeAppendSeparator().append(d);
            return this;
        }

        public ToStringHelper addValue(float f) {
            this.maybeAppendSeparator().append(f);
            return this;
        }

        public ToStringHelper addValue(int n) {
            this.maybeAppendSeparator().append(n);
            return this;
        }

        public ToStringHelper addValue(long l) {
            this.maybeAppendSeparator().append(l);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            try {
                String string = this.builder.append('}').toString();
                return string;
            }
            finally {
                this.builder.setLength(this.builder.length() - 1);
            }
        }

        private StringBuilder maybeAppendSeparator() {
            if (this.needsSeparator) {
                return this.builder.append(", ");
            }
            this.needsSeparator = true;
            return this.builder;
        }
    }
}

