/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected AbstractCache() {
    }

    @Override
    public V get(K k, Callable<? extends V> callable) throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableMap<K, V> getAllPresent(Iterable<? extends K> iterable) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (K k : iterable) {
            if (linkedHashMap.containsKey(k)) continue;
            linkedHashMap.put(k, this.getIfPresent(k));
        }
        return ImmutableMap.copyOf(linkedHashMap);
    }

    @Override
    public void put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateAll(Iterable<?> iterable) {
        for (Object obj : iterable) {
            this.invalidate(obj);
        }
    }

    @Override
    public void invalidateAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStats stats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V getUnchecked(K k) {
        try {
            return this.get(k);
        }
        catch (ExecutionException executionException) {
            throw new UncheckedExecutionException(executionException.getCause());
        }
    }

    @Override
    @Deprecated
    public V apply(K k) {
        return this.getUnchecked(k);
    }

    @Beta
    public static class SimpleStatsCounter
    implements StatsCounter {
        private final AtomicLong hitCount = new AtomicLong();
        private final AtomicLong missCount = new AtomicLong();
        private final AtomicLong loadSuccessCount = new AtomicLong();
        private final AtomicLong loadExceptionCount = new AtomicLong();
        private final AtomicLong totalLoadTime = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();

        public void recordHits(int n) {
            this.hitCount.addAndGet(n);
        }

        public void recordMisses(int n) {
            this.missCount.addAndGet(n);
        }

        public void recordLoadSuccess(long l) {
            this.loadSuccessCount.incrementAndGet();
            this.totalLoadTime.addAndGet(l);
        }

        public void recordLoadException(long l) {
            this.loadExceptionCount.incrementAndGet();
            this.totalLoadTime.addAndGet(l);
        }

        public void recordEviction() {
            this.evictionCount.incrementAndGet();
        }

        public CacheStats snapshot() {
            return new CacheStats(this.hitCount.get(), this.missCount.get(), this.loadSuccessCount.get(), this.loadExceptionCount.get(), this.totalLoadTime.get(), this.evictionCount.get());
        }

        public void incrementBy(StatsCounter statsCounter) {
            CacheStats cacheStats = statsCounter.snapshot();
            this.hitCount.addAndGet(cacheStats.hitCount());
            this.missCount.addAndGet(cacheStats.missCount());
            this.loadSuccessCount.addAndGet(cacheStats.loadSuccessCount());
            this.loadExceptionCount.addAndGet(cacheStats.loadExceptionCount());
            this.totalLoadTime.addAndGet(cacheStats.totalLoadTime());
            this.evictionCount.addAndGet(cacheStats.evictionCount());
        }
    }

    @Beta
    public static interface StatsCounter {
        public void recordHits(int var1);

        public void recordMisses(int var1);

        public void recordLoadSuccess(long var1);

        public void recordLoadException(long var1);

        public void recordEviction();

        public CacheStats snapshot();
    }
}

