/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class ForwardingCache<K, V>
extends ForwardingObject
implements Cache<K, V> {
    protected ForwardingCache() {
    }

    @Override
    protected abstract Cache<K, V> delegate();

    @Override
    @Nullable
    public V getIfPresent(K k) {
        return this.delegate().getIfPresent(k);
    }

    @Override
    public V get(K k, Callable<? extends V> callable) throws ExecutionException {
        return this.delegate().get(k, callable);
    }

    @Override
    public ImmutableMap<K, V> getAllPresent(Iterable<? extends K> iterable) {
        return this.delegate().getAllPresent(iterable);
    }

    @Override
    public void put(K k, V v) {
        this.delegate().put(k, v);
    }

    @Override
    public void invalidate(Object object) {
        this.delegate().invalidate(object);
    }

    @Override
    public void invalidateAll(Iterable<?> iterable) {
        this.delegate().invalidateAll(iterable);
    }

    @Override
    public void invalidateAll() {
        this.delegate().invalidateAll();
    }

    @Override
    public long size() {
        return this.delegate().size();
    }

    @Override
    public CacheStats stats() {
        return this.delegate().stats();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this.delegate().asMap();
    }

    @Override
    public void cleanUp() {
        this.delegate().cleanUp();
    }

    @Override
    @Deprecated
    public V get(K k) throws ExecutionException {
        return this.delegate().get(k);
    }

    @Override
    @Deprecated
    public V getUnchecked(K k) {
        return this.delegate().getUnchecked(k);
    }

    @Override
    @Deprecated
    public V apply(K k) {
        return this.delegate().apply(k);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static abstract class SimpleForwardingCache<K, V>
    extends ForwardingCache<K, V> {
        private final Cache<K, V> delegate;

        protected SimpleForwardingCache(Cache<K, V> cache) {
            this.delegate = Preconditions.checkNotNull(cache);
        }

        @Override
        protected final Cache<K, V> delegate() {
            return this.delegate;
        }
    }
}

