/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BstNode;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
final class BstModificationResult<N extends BstNode<?, N>> {
    @Nullable
    private final N originalTarget;
    @Nullable
    private final N changedTarget;
    private final ModificationType type;

    static <N extends BstNode<?, N>> BstModificationResult<N> identity(@Nullable N n) {
        return new BstModificationResult<N>(n, n, ModificationType.IDENTITY);
    }

    static <N extends BstNode<?, N>> BstModificationResult<N> rebuildingChange(@Nullable N n, @Nullable N n2) {
        return new BstModificationResult<N>(n, n2, ModificationType.REBUILDING_CHANGE);
    }

    static <N extends BstNode<?, N>> BstModificationResult<N> rebalancingChange(@Nullable N n, @Nullable N n2) {
        return new BstModificationResult<N>(n, n2, ModificationType.REBALANCING_CHANGE);
    }

    private BstModificationResult(@Nullable N n, @Nullable N n2, ModificationType modificationType) {
        this.originalTarget = n;
        this.changedTarget = n2;
        this.type = Preconditions.checkNotNull(modificationType);
    }

    @Nullable
    N getOriginalTarget() {
        return this.originalTarget;
    }

    @Nullable
    N getChangedTarget() {
        return this.changedTarget;
    }

    ModificationType getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ModificationType {
        IDENTITY,
        REBUILDING_CHANGE,
        REBALANCING_CHANGE;

    }
}

