/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BstBalancePolicy;
import com.google.common.collect.BstModificationResult;
import com.google.common.collect.BstNode;
import com.google.common.collect.BstNodeFactory;
import com.google.common.collect.BstSide;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
final class BstMutationResult<K, N extends BstNode<K, N>> {
    private final K targetKey;
    @Nullable
    private N originalRoot;
    @Nullable
    private N changedRoot;
    private final BstModificationResult<N> modificationResult;

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> mutationResult(@Nullable K k, @Nullable N n, @Nullable N n2, BstModificationResult<N> bstModificationResult) {
        return new BstMutationResult<K, N>(k, n, n2, bstModificationResult);
    }

    private BstMutationResult(@Nullable K k, @Nullable N n, @Nullable N n2, BstModificationResult<N> bstModificationResult) {
        this.targetKey = k;
        this.originalRoot = n;
        this.changedRoot = n2;
        this.modificationResult = Preconditions.checkNotNull(bstModificationResult);
    }

    public K getTargetKey() {
        return this.targetKey;
    }

    @Nullable
    public N getOriginalRoot() {
        return this.originalRoot;
    }

    @Nullable
    public N getChangedRoot() {
        return this.changedRoot;
    }

    @Nullable
    public N getOriginalTarget() {
        return this.modificationResult.getOriginalTarget();
    }

    @Nullable
    public N getChangedTarget() {
        return this.modificationResult.getChangedTarget();
    }

    BstModificationResult.ModificationType modificationType() {
        return this.modificationResult.getType();
    }

    public BstMutationResult<K, N> lift(N n, BstSide bstSide, BstNodeFactory<N> bstNodeFactory, BstBalancePolicy<N> bstBalancePolicy) {
        assert (n != null & bstSide != null & bstNodeFactory != null & bstBalancePolicy != null);
        switch (this.modificationType()) {
            case IDENTITY: {
                this.changedRoot = n;
                this.originalRoot = this.changedRoot;
                return this;
            }
            case REBUILDING_CHANGE: 
            case REBALANCING_CHANGE: {
                this.originalRoot = n;
                Object n2 = ((BstNode)n).childOrNull(BstSide.LEFT);
                Object n3 = ((BstNode)n).childOrNull(BstSide.RIGHT);
                switch (bstSide) {
                    case LEFT: {
                        n2 = this.changedRoot;
                        break;
                    }
                    case RIGHT: {
                        n3 = this.changedRoot;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.changedRoot = this.modificationType() == BstModificationResult.ModificationType.REBUILDING_CHANGE ? bstNodeFactory.createNode(n, n2, n3) : bstBalancePolicy.balance(bstNodeFactory, n, n2, n3);
                return this;
            }
        }
        throw new AssertionError();
    }
}

