/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Collections2 {
    static final Joiner STANDARD_JOINER = Joiner.on(", ");

    private Collections2() {
    }

    public static <E> Collection<E> filter(Collection<E> collection, Predicate<? super E> predicate) {
        if (collection instanceof FilteredCollection) {
            return ((FilteredCollection)collection).createCombined(predicate);
        }
        return new FilteredCollection<E>(Preconditions.checkNotNull(collection), Preconditions.checkNotNull(predicate));
    }

    static boolean safeContains(Collection<?> collection, Object object) {
        try {
            return collection.contains(object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static <F, T> Collection<T> transform(Collection<F> collection, Function<? super F, T> function) {
        return new TransformedCollection<F, T>(collection, function);
    }

    static boolean containsAllImpl(Collection<?> collection, Collection<?> collection2) {
        Preconditions.checkNotNull(collection);
        for (Object obj : collection2) {
            if (collection.contains(obj)) continue;
            return false;
        }
        return true;
    }

    static String toStringImpl(final Collection<?> collection) {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(collection.size()).append('[');
        STANDARD_JOINER.appendTo(stringBuilder, Iterables.transform(collection, new Function<Object, Object>(){

            @Override
            public Object apply(Object object) {
                return object == collection ? "(this Collection)" : object;
            }
        }));
        return stringBuilder.append(']').toString();
    }

    static StringBuilder newStringBuilderForCollection(int n) {
        Preconditions.checkArgument(n >= 0, "size must be non-negative");
        return new StringBuilder((int)Math.min((long)n * 8L, 0x40000000L));
    }

    static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TransformedCollection<F, T>
    extends AbstractCollection<T> {
        final Collection<F> fromCollection;
        final Function<? super F, ? extends T> function;

        TransformedCollection(Collection<F> collection, Function<? super F, ? extends T> function) {
            this.fromCollection = Preconditions.checkNotNull(collection);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromCollection.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.fromCollection.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.transform(this.fromCollection.iterator(), this.function);
        }

        @Override
        public int size() {
            return this.fromCollection.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilteredCollection<E>
    implements Collection<E> {
        final Collection<E> unfiltered;
        final Predicate<? super E> predicate;

        FilteredCollection(Collection<E> collection, Predicate<? super E> predicate) {
            this.unfiltered = collection;
            this.predicate = predicate;
        }

        FilteredCollection<E> createCombined(Predicate<? super E> predicate) {
            return new FilteredCollection<E>(this.unfiltered, Predicates.and(this.predicate, predicate));
        }

        @Override
        public boolean add(E e) {
            Preconditions.checkArgument(this.predicate.apply(e));
            return this.unfiltered.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            for (E e : collection) {
                Preconditions.checkArgument(this.predicate.apply(e));
            }
            return this.unfiltered.addAll(collection);
        }

        @Override
        public void clear() {
            Iterables.removeIf(this.unfiltered, this.predicate);
        }

        @Override
        public boolean contains(Object object) {
            try {
                Object object2 = object;
                return this.predicate.apply(object2) && this.unfiltered.contains(object);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !Iterators.any(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.filter(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public boolean remove(Object object) {
            try {
                Object object2 = object;
                return this.predicate.apply(object2) && this.unfiltered.remove(object);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        public boolean removeAll(final Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            Predicate predicate = new Predicate<E>(){

                @Override
                public boolean apply(E e) {
                    return FilteredCollection.this.predicate.apply(e) && collection.contains(e);
                }
            };
            return Iterables.removeIf(this.unfiltered, predicate);
        }

        @Override
        public boolean retainAll(final Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            Predicate predicate = new Predicate<E>(){

                @Override
                public boolean apply(E e) {
                    return FilteredCollection.this.predicate.apply(e) && !collection.contains(e);
                }
            };
            return Iterables.removeIf(this.unfiltered, predicate);
        }

        @Override
        public int size() {
            return Iterators.size(this.iterator());
        }

        @Override
        public Object[] toArray() {
            return Lists.newArrayList(this.iterator()).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return Lists.newArrayList(this.iterator()).toArray(TArray);
        }

        public String toString() {
            return Iterators.toString(this.iterator());
        }
    }
}

