/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public abstract class ContiguousSet<C extends Comparable>
extends ImmutableSortedSet<C> {
    final DiscreteDomain<C> domain;

    ContiguousSet(DiscreteDomain<C> discreteDomain) {
        super(Ordering.natural());
        this.domain = discreteDomain;
    }

    @Override
    public ContiguousSet<C> headSet(C c) {
        return this.headSet((C)((Comparable)Preconditions.checkNotNull(c)), false);
    }

    @Override
    ContiguousSet<C> headSet(C c, boolean bl) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(c)), bl);
    }

    @Override
    public ContiguousSet<C> subSet(C c, C c2) {
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(c2);
        Preconditions.checkArgument(this.comparator().compare(c, c2) <= 0);
        return this.subSet(c, true, c2, false);
    }

    @Override
    ContiguousSet<C> subSet(C c, boolean bl, C c2, boolean bl2) {
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(c2);
        Preconditions.checkArgument(this.comparator().compare(c, c2) <= 0);
        return this.subSetImpl(c, bl, c2, bl2);
    }

    @Override
    public ContiguousSet<C> tailSet(C c) {
        return this.tailSet((C)((Comparable)Preconditions.checkNotNull(c)), true);
    }

    @Override
    ContiguousSet<C> tailSet(C c, boolean bl) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(c)), bl);
    }

    @Override
    abstract ContiguousSet<C> headSetImpl(C var1, boolean var2);

    @Override
    abstract ContiguousSet<C> subSetImpl(C var1, boolean var2, C var3, boolean var4);

    @Override
    abstract ContiguousSet<C> tailSetImpl(C var1, boolean var2);

    public abstract ContiguousSet<C> intersection(ContiguousSet<C> var1);

    public abstract Range<C> range();

    public abstract Range<C> range(BoundType var1, BoundType var2);

    @Override
    public String toString() {
        return this.range().toString();
    }
}

