/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.BoundType;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Multisets {
    private static final Ordering<Multiset.Entry<?>> DECREASING_COUNT_ORDERING = new Ordering<Multiset.Entry<?>>(){

        @Override
        public int compare(Multiset.Entry<?> entry, Multiset.Entry<?> entry2) {
            return Ints.compare(entry2.getCount(), entry.getCount());
        }
    };

    private Multisets() {
    }

    public static <E> Multiset<E> unmodifiableMultiset(Multiset<? extends E> multiset) {
        if (multiset instanceof UnmodifiableMultiset || multiset instanceof ImmutableMultiset) {
            Multiset<? extends E> multiset2 = multiset;
            return multiset2;
        }
        return new UnmodifiableMultiset<E>(Preconditions.checkNotNull(multiset));
    }

    @Deprecated
    public static <E> Multiset<E> unmodifiableMultiset(ImmutableMultiset<E> immutableMultiset) {
        return Preconditions.checkNotNull(immutableMultiset);
    }

    @Beta
    public static <E> SortedMultiset<E> unmodifiableSortedMultiset(SortedMultiset<E> sortedMultiset) {
        return new UnmodifiableSortedMultiset(Preconditions.checkNotNull(sortedMultiset));
    }

    public static <E> Multiset.Entry<E> immutableEntry(@Nullable E e, int n) {
        return new ImmutableEntry<E>(e, n);
    }

    static <E> Multiset<E> forSet(Set<E> set) {
        return new SetMultiset<E>(set);
    }

    static int inferDistinctElements(Iterable<?> iterable) {
        if (iterable instanceof Multiset) {
            return ((Multiset)iterable).elementSet().size();
        }
        return 11;
    }

    public static <E> Multiset<E> intersection(final Multiset<E> multiset, final Multiset<?> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        return new AbstractMultiset<E>(){

            @Override
            public int count(Object object) {
                int n = multiset.count(object);
                return n == 0 ? 0 : Math.min(n, multiset2.count(object));
            }

            @Override
            Set<E> createElementSet() {
                return Sets.intersection(multiset.elementSet(), multiset2.elementSet());
            }

            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                final Iterator iterator = multiset.entrySet().iterator();
                return new AbstractIterator<Multiset.Entry<E>>(){

                    @Override
                    protected Multiset.Entry<E> computeNext() {
                        while (iterator.hasNext()) {
                            Multiset.Entry entry = (Multiset.Entry)iterator.next();
                            Object e = entry.getElement();
                            int n = Math.min(entry.getCount(), multiset2.count(e));
                            if (n <= 0) continue;
                            return Multisets.immutableEntry(e, n);
                        }
                        return (Multiset.Entry)this.endOfData();
                    }
                };
            }

            @Override
            int distinctElements() {
                return this.elementSet().size();
            }
        };
    }

    @Beta
    public static boolean containsOccurrences(Multiset<?> multiset, Multiset<?> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        for (Multiset.Entry<?> entry : multiset2.entrySet()) {
            int n = multiset.count(entry.getElement());
            if (n >= entry.getCount()) continue;
            return false;
        }
        return true;
    }

    @Beta
    public static boolean retainOccurrences(Multiset<?> multiset, Multiset<?> multiset2) {
        return Multisets.retainOccurrencesImpl(multiset, multiset2);
    }

    private static <E> boolean retainOccurrencesImpl(Multiset<E> multiset, Multiset<?> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        Iterator<Multiset.Entry<E>> iterator = multiset.entrySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Multiset.Entry<E> entry = iterator.next();
            int n = multiset2.count(entry.getElement());
            if (n == 0) {
                iterator.remove();
                bl = true;
                continue;
            }
            if (n >= entry.getCount()) continue;
            multiset.setCount(entry.getElement(), n);
            bl = true;
        }
        return bl;
    }

    @Beta
    public static boolean removeOccurrences(Multiset<?> multiset, Multiset<?> multiset2) {
        return Multisets.removeOccurrencesImpl(multiset, multiset2);
    }

    private static <E> boolean removeOccurrencesImpl(Multiset<E> multiset, Multiset<?> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        boolean bl = false;
        Iterator<Multiset.Entry<E>> iterator = multiset.entrySet().iterator();
        while (iterator.hasNext()) {
            Multiset.Entry<E> entry = iterator.next();
            int n = multiset2.count(entry.getElement());
            if (n >= entry.getCount()) {
                iterator.remove();
                bl = true;
                continue;
            }
            if (n <= 0) continue;
            multiset.remove(entry.getElement(), n);
            bl = true;
        }
        return bl;
    }

    static boolean equalsImpl(Multiset<?> multiset, @Nullable Object object) {
        if (object == multiset) {
            return true;
        }
        if (object instanceof Multiset) {
            Multiset multiset2 = (Multiset)object;
            if (multiset.size() != multiset2.size() || multiset.entrySet().size() != multiset2.entrySet().size()) {
                return false;
            }
            for (Multiset.Entry entry : multiset2.entrySet()) {
                if (multiset.count(entry.getElement()) == entry.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static <E> boolean addAllImpl(Multiset<E> multiset, Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection instanceof Multiset) {
            Multiset<E> multiset2 = Multisets.cast(collection);
            for (Multiset.Entry<E> entry : multiset2.entrySet()) {
                multiset.add(entry.getElement(), entry.getCount());
            }
        } else {
            Iterators.addAll(multiset, collection.iterator());
        }
        return true;
    }

    static boolean removeAllImpl(Multiset<?> multiset, Collection<?> collection) {
        Collection<?> collection2 = collection instanceof Multiset ? ((Multiset)collection).elementSet() : collection;
        return multiset.elementSet().removeAll(collection2);
    }

    static boolean retainAllImpl(Multiset<?> multiset, Collection<?> collection) {
        Collection<?> collection2 = collection instanceof Multiset ? ((Multiset)collection).elementSet() : collection;
        return multiset.elementSet().retainAll(collection2);
    }

    static <E> int setCountImpl(Multiset<E> multiset, E e, int n) {
        Multisets.checkNonnegative(n, "count");
        int n2 = multiset.count(e);
        int n3 = n - n2;
        if (n3 > 0) {
            multiset.add(e, n3);
        } else if (n3 < 0) {
            multiset.remove(e, -n3);
        }
        return n2;
    }

    static <E> boolean setCountImpl(Multiset<E> multiset, E e, int n, int n2) {
        Multisets.checkNonnegative(n, "oldCount");
        Multisets.checkNonnegative(n2, "newCount");
        if (multiset.count(e) == n) {
            multiset.setCount(e, n2);
            return true;
        }
        return false;
    }

    static <E> Iterator<E> iteratorImpl(Multiset<E> multiset) {
        return new MultisetIteratorImpl<E>(multiset, multiset.entrySet().iterator());
    }

    static int sizeImpl(Multiset<?> multiset) {
        long l = 0L;
        for (Multiset.Entry<?> entry : multiset.entrySet()) {
            l += (long)entry.getCount();
        }
        return Ints.saturatedCast(l);
    }

    static void checkNonnegative(int n, String string) {
        Preconditions.checkArgument(n >= 0, "%s cannot be negative: %s", string, n);
    }

    static <T> Multiset<T> cast(Iterable<T> iterable) {
        return (Multiset)iterable;
    }

    @Beta
    public static <E> ImmutableMultiset<E> copyHighestCountFirst(Multiset<E> multiset) {
        List<Multiset.Entry<E>> list = DECREASING_COUNT_ORDERING.sortedCopy(multiset.entrySet());
        return ImmutableMultiset.copyFromEntries(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MultisetIteratorImpl<E>
    implements Iterator<E> {
        private final Multiset<E> multiset;
        private final Iterator<Multiset.Entry<E>> entryIterator;
        private Multiset.Entry<E> currentEntry;
        private int laterCount;
        private int totalCount;
        private boolean canRemove;

        MultisetIteratorImpl(Multiset<E> multiset, Iterator<Multiset.Entry<E>> iterator) {
            this.multiset = multiset;
            this.entryIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.laterCount > 0 || this.entryIterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.laterCount == 0) {
                this.currentEntry = this.entryIterator.next();
                this.totalCount = this.laterCount = this.currentEntry.getCount();
            }
            --this.laterCount;
            this.canRemove = true;
            return this.currentEntry.getElement();
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.canRemove, "no calls to next() since the last call to remove()");
            if (this.totalCount == 1) {
                this.entryIterator.remove();
            } else {
                this.multiset.remove(this.currentEntry.getElement());
            }
            --this.totalCount;
            this.canRemove = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class EntrySet<E>
    extends AbstractSet<Multiset.Entry<E>> {
        EntrySet() {
        }

        abstract Multiset<E> multiset();

        @Override
        public boolean contains(@Nullable Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int n = this.multiset().count(entry.getElement());
                return n == entry.getCount();
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            return this.contains(object) && this.multiset().elementSet().remove(((Multiset.Entry)object).getElement());
        }

        @Override
        public void clear() {
            this.multiset().clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ElementSet<E>
    extends AbstractSet<E> {
        ElementSet() {
        }

        abstract Multiset<E> multiset();

        @Override
        public void clear() {
            this.multiset().clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.multiset().contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.multiset().containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.multiset().isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.transform(this.multiset().entrySet().iterator(), new Function<Multiset.Entry<E>, E>(){

                @Override
                public E apply(Multiset.Entry<E> entry) {
                    return entry.getElement();
                }
            });
        }

        @Override
        public boolean remove(Object object) {
            int n = this.multiset().count(object);
            if (n > 0) {
                this.multiset().remove(object, n);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.multiset().entrySet().size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractEntry<E>
    implements Multiset.Entry<E> {
        AbstractEntry() {
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                return this.getCount() == entry.getCount() && Objects.equal(this.getElement(), entry.getElement());
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object e = this.getElement();
            return (e == null ? 0 : e.hashCode()) ^ this.getCount();
        }

        @Override
        public String toString() {
            String string = String.valueOf(this.getElement());
            int n = this.getCount();
            return n == 1 ? string : string + " x " + n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetMultiset<E>
    extends ForwardingCollection<E>
    implements Multiset<E>,
    Serializable {
        final Set<E> delegate;
        transient Set<E> elementSet;
        transient Set<Multiset.Entry<E>> entrySet;
        private static final long serialVersionUID = 0L;

        SetMultiset(Set<E> set) {
            this.delegate = Preconditions.checkNotNull(set);
        }

        @Override
        protected Set<E> delegate() {
            return this.delegate;
        }

        @Override
        public int count(Object object) {
            return this.delegate.contains(object) ? 1 : 0;
        }

        @Override
        public int add(E e, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Object object, int n) {
            if (n == 0) {
                return this.count(object);
            }
            Preconditions.checkArgument(n > 0);
            return this.delegate.remove(object) ? 1 : 0;
        }

        @Override
        public Set<E> elementSet() {
            ElementSet elementSet = this.elementSet;
            return elementSet == null ? (this.elementSet = new ElementSet()) : elementSet;
        }

        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            EntrySet entrySet = this.entrySet;
            if (entrySet == null) {
                entrySet = this.entrySet = new EntrySet<E>(){

                    @Override
                    Multiset<E> multiset() {
                        return SetMultiset.this;
                    }

                    @Override
                    public Iterator<Multiset.Entry<E>> iterator() {
                        return Iterators.transform(SetMultiset.this.delegate.iterator(), new Function<E, Multiset.Entry<E>>(){

                            @Override
                            public Multiset.Entry<E> apply(E e) {
                                return Multisets.immutableEntry(e, 1);
                            }
                        });
                    }

                    @Override
                    public int size() {
                        return SetMultiset.this.delegate.size();
                    }
                };
            }
            return entrySet;
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setCount(E e, int n) {
            Multisets.checkNonnegative(n, "count");
            if (n == this.count(e)) {
                return n;
            }
            if (n == 0) {
                this.remove(e);
                return 1;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setCount(E e, int n, int n2) {
            return Multisets.setCountImpl(this, e, n, n2);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Multiset) {
                Multiset multiset = (Multiset)object;
                return this.size() == multiset.size() && ((Object)this.delegate).equals(multiset.elementSet());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = 0;
            for (Object e : this) {
                n += (e == null ? 0 : e.hashCode()) ^ 1;
            }
            return n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ElementSet
        extends ForwardingSet<E> {
            ElementSet() {
            }

            @Override
            protected Set<E> delegate() {
                return SetMultiset.this.delegate;
            }

            @Override
            public boolean add(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> collection) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ImmutableEntry<E>
    extends AbstractEntry<E>
    implements Serializable {
        @Nullable
        final E element;
        final int count;
        private static final long serialVersionUID = 0L;

        ImmutableEntry(@Nullable E e, int n) {
            this.element = e;
            this.count = n;
            Preconditions.checkArgument(n >= 0);
        }

        @Override
        @Nullable
        public E getElement() {
            return this.element;
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableSortedMultiset<E>
    extends UnmodifiableMultiset<E>
    implements SortedMultiset<E> {
        private transient UnmodifiableSortedMultiset<E> descendingMultiset;
        private static final long serialVersionUID = 0L;

        private UnmodifiableSortedMultiset(SortedMultiset<E> sortedMultiset) {
            super(sortedMultiset);
        }

        @Override
        protected SortedMultiset<E> delegate() {
            return (SortedMultiset)super.delegate();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.delegate().comparator();
        }

        @Override
        SortedSet<E> createElementSet() {
            return Collections.unmodifiableSortedSet(this.delegate().elementSet());
        }

        @Override
        public SortedSet<E> elementSet() {
            return (SortedSet)super.elementSet();
        }

        @Override
        public SortedMultiset<E> descendingMultiset() {
            UnmodifiableSortedMultiset<E> unmodifiableSortedMultiset = this.descendingMultiset;
            if (unmodifiableSortedMultiset == null) {
                unmodifiableSortedMultiset = new UnmodifiableSortedMultiset(this.delegate().descendingMultiset());
                unmodifiableSortedMultiset.descendingMultiset = this;
                this.descendingMultiset = unmodifiableSortedMultiset;
                return this.descendingMultiset;
            }
            return unmodifiableSortedMultiset;
        }

        @Override
        public Multiset.Entry<E> firstEntry() {
            return this.delegate().firstEntry();
        }

        @Override
        public Multiset.Entry<E> lastEntry() {
            return this.delegate().lastEntry();
        }

        @Override
        public Multiset.Entry<E> pollFirstEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Multiset.Entry<E> pollLastEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMultiset<E> headMultiset(E e, BoundType boundType) {
            return Multisets.unmodifiableSortedMultiset(this.delegate().headMultiset(e, boundType));
        }

        @Override
        public SortedMultiset<E> subMultiset(E e, BoundType boundType, E e2, BoundType boundType2) {
            return Multisets.unmodifiableSortedMultiset(this.delegate().subMultiset(e, boundType, e2, boundType2));
        }

        @Override
        public SortedMultiset<E> tailMultiset(E e, BoundType boundType) {
            return Multisets.unmodifiableSortedMultiset(this.delegate().tailMultiset(e, boundType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableMultiset<E>
    extends ForwardingMultiset<E>
    implements Serializable {
        final Multiset<? extends E> delegate;
        transient Set<E> elementSet;
        transient Set<Multiset.Entry<E>> entrySet;
        private static final long serialVersionUID = 0L;

        UnmodifiableMultiset(Multiset<? extends E> multiset) {
            this.delegate = multiset;
        }

        @Override
        protected Multiset<E> delegate() {
            return this.delegate;
        }

        Set<E> createElementSet() {
            return Collections.unmodifiableSet(this.delegate.elementSet());
        }

        @Override
        public Set<E> elementSet() {
            Set<E> set = this.elementSet;
            return set == null ? (this.elementSet = this.createElementSet()) : set;
        }

        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            Set<Multiset.Entry<Multiset.Entry<E>>> set = this.entrySet;
            return set == null ? (this.entrySet = Collections.unmodifiableSet(this.delegate.entrySet())) : set;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.unmodifiableIterator(this.delegate.iterator());
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int add(E e, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Object object, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setCount(E e, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setCount(E e, int n, int n2) {
            throw new UnsupportedOperationException();
        }
    }
}

