/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ByFunctionOrdering;
import com.google.common.collect.ComparatorOrdering;
import com.google.common.collect.CompoundOrdering;
import com.google.common.collect.ExplicitOrdering;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.NaturalOrdering;
import com.google.common.collect.NullsFirstOrdering;
import com.google.common.collect.NullsLastOrdering;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Platform;
import com.google.common.collect.ReverseOrdering;
import com.google.common.collect.UsingToStringOrdering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(List<T> list) {
        return new ExplicitOrdering<T>(list);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(T t, T ... TArray) {
        return Ordering.explicit(Lists.asList(t, TArray));
    }

    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> iterable) {
        return new CompoundOrdering(iterable);
    }

    protected Ordering() {
    }

    @GwtCompatible(serializable=true)
    public <U extends T> Ordering<U> compound(Comparator<? super U> comparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(comparator));
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);

    @Beta
    public <E extends T> List<E> leastOf(Iterable<E> iterable, int n) {
        Object[] objectArray;
        Preconditions.checkArgument(n >= 0, "%d is negative", n);
        Object[] objectArray2 = Iterables.toArray(iterable);
        if (objectArray2.length <= n) {
            Arrays.sort(objectArray2, this);
            objectArray = objectArray2;
        } else {
            this.quicksortLeastK(objectArray2, 0, objectArray2.length - 1, n);
            Object[] objectArray3 = new Object[n];
            objectArray = objectArray3;
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
        }
        return Collections.unmodifiableList(Arrays.asList(objectArray));
    }

    @Beta
    public <E extends T> List<E> greatestOf(Iterable<E> iterable, int n) {
        return this.reverse().leastOf(iterable, n);
    }

    private <E extends T> void quicksortLeastK(E[] EArray, int n, int n2, int n3) {
        if (n2 > n) {
            int n4 = n + n2 >>> 1;
            int n5 = this.partition(EArray, n, n2, n4);
            this.quicksortLeastK(EArray, n, n5 - 1, n3);
            if (n5 < n3) {
                this.quicksortLeastK(EArray, n5 + 1, n2, n3);
            }
        }
    }

    private <E extends T> int partition(E[] EArray, int n, int n2, int n3) {
        E e = EArray[n3];
        EArray[n3] = EArray[n2];
        EArray[n2] = e;
        int n4 = n;
        for (int i = n; i < n2; ++i) {
            if (this.compare(EArray[i], e) >= 0) continue;
            ObjectArrays.swap(EArray, n4, i);
            ++n4;
        }
        ObjectArrays.swap(EArray, n2, n4);
        return n4;
    }

    public int binarySearch(List<? extends T> list, @Nullable T t) {
        return Collections.binarySearch(list, t, this);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
        ArrayList<E> arrayList = Lists.newArrayList(iterable);
        Collections.sort(arrayList, this);
        return arrayList;
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
        return ImmutableList.copyOf(this.sortedCopy(iterable));
    }

    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            while (iterator.hasNext()) {
                T t2 = iterator.next();
                if (this.compare(t, t2) > 0) {
                    return false;
                }
                t = t2;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            while (iterator.hasNext()) {
                T t2 = iterator.next();
                if (this.compare(t, t2) >= 0) {
                    return false;
                }
                t = t2;
            }
        }
        return true;
    }

    @Beta
    public <E extends T> E max(Iterator<E> iterator) {
        E e = iterator.next();
        while (iterator.hasNext()) {
            e = this.max(e, iterator.next());
        }
        return e;
    }

    public <E extends T> E max(Iterable<E> iterable) {
        return this.max(iterable.iterator());
    }

    public <E extends T> E max(@Nullable E e, @Nullable E e2, @Nullable E e3, E ... EArray) {
        E e4 = this.max(this.max(e, e2), e3);
        for (E e5 : EArray) {
            e4 = this.max(e4, e5);
        }
        return e4;
    }

    public <E extends T> E max(@Nullable E e, @Nullable E e2) {
        return this.compare(e, e2) >= 0 ? e : e2;
    }

    @Beta
    public <E extends T> E min(Iterator<E> iterator) {
        E e = iterator.next();
        while (iterator.hasNext()) {
            e = this.min(e, iterator.next());
        }
        return e;
    }

    public <E extends T> E min(Iterable<E> iterable) {
        return this.min(iterable.iterator());
    }

    public <E extends T> E min(@Nullable E e, @Nullable E e2, @Nullable E e3, E ... EArray) {
        E e4 = this.min(this.min(e, e2), e3);
        for (E e5 : EArray) {
            e4 = this.min(e4, e5);
        }
        return e4;
    }

    public <E extends T> E min(@Nullable E e, @Nullable E e2) {
        return this.compare(e, e2) <= 0 ? e : e2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @VisibleForTesting
    static class ArbitraryOrdering
    extends Ordering<Object> {
        private Map<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeComputingMap(new Function<Object, Integer>(){
            final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Integer apply(Object object) {
                return this.counter.getAndIncrement();
            }
        });

        ArbitraryOrdering() {
        }

        @Override
        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            int n2 = this.identityHashCode(object);
            if (n2 != (n = this.identityHashCode(object2))) {
                return n2 < n ? -1 : 1;
            }
            int n3 = this.uids.get(object).compareTo(this.uids.get(object2));
            if (n3 == 0) {
                throw new AssertionError();
            }
            return n3;
        }

        public String toString() {
            return "Ordering.arbitrary()";
        }

        int identityHashCode(Object object) {
            return System.identityHashCode(object);
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }

    @VisibleForTesting
    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(Object object) {
            super("Cannot compare value: " + object);
            this.value = object;
        }
    }
}

