/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.Cut;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@Beta
public final class Ranges {
    private Ranges() {
    }

    static <C extends Comparable<?>> Range<C> create(Cut<C> cut, Cut<C> cut2) {
        return new Range<C>(cut, cut2);
    }

    public static <C extends Comparable<?>> Range<C> open(C c, C c2) {
        return Ranges.create(Cut.aboveValue(c), Cut.belowValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> closed(C c, C c2) {
        return Ranges.create(Cut.belowValue(c), Cut.aboveValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> closedOpen(C c, C c2) {
        return Ranges.create(Cut.belowValue(c), Cut.belowValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> openClosed(C c, C c2) {
        return Ranges.create(Cut.aboveValue(c), Cut.aboveValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> range(C c, BoundType boundType, C c2, BoundType boundType2) {
        Preconditions.checkNotNull(boundType);
        Preconditions.checkNotNull(boundType2);
        Cut<C> cut = boundType == BoundType.OPEN ? Cut.aboveValue(c) : Cut.belowValue(c);
        Cut<C> cut2 = boundType2 == BoundType.OPEN ? Cut.belowValue(c2) : Cut.aboveValue(c2);
        return Ranges.create(cut, cut2);
    }

    public static <C extends Comparable<?>> Range<C> lessThan(C c) {
        return Ranges.create(Cut.belowAll(), Cut.belowValue(c));
    }

    public static <C extends Comparable<?>> Range<C> atMost(C c) {
        return Ranges.create(Cut.belowAll(), Cut.aboveValue(c));
    }

    public static <C extends Comparable<?>> Range<C> upTo(C c, BoundType boundType) {
        switch (boundType) {
            case OPEN: {
                return Ranges.lessThan(c);
            }
            case CLOSED: {
                return Ranges.atMost(c);
            }
        }
        throw new AssertionError();
    }

    public static <C extends Comparable<?>> Range<C> greaterThan(C c) {
        return Ranges.create(Cut.aboveValue(c), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> atLeast(C c) {
        return Ranges.create(Cut.belowValue(c), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> downTo(C c, BoundType boundType) {
        switch (boundType) {
            case OPEN: {
                return Ranges.greaterThan(c);
            }
            case CLOSED: {
                return Ranges.atLeast(c);
            }
        }
        throw new AssertionError();
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return Ranges.create(Cut.belowAll(), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> singleton(C c) {
        return Ranges.closed(c, c);
    }

    public static <C extends Comparable<?>> Range<C> encloseAll(Iterable<C> iterable) {
        Comparable comparable;
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof ContiguousSet) {
            return ((ContiguousSet)iterable).range();
        }
        Iterator<C> iterator = iterable.iterator();
        Comparable comparable2 = comparable = (Comparable)Preconditions.checkNotNull(iterator.next());
        while (iterator.hasNext()) {
            Comparable comparable3 = (Comparable)Preconditions.checkNotNull(iterator.next());
            comparable = Ordering.natural().min(comparable, comparable3);
            comparable2 = Ordering.natural().max(comparable2, comparable3);
        }
        return Ranges.closed(comparable, comparable2);
    }
}

