/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSet<E>
extends ImmutableSet.ArrayImmutableSet<E> {
    @VisibleForTesting
    final transient Object[] table;
    private final transient int mask;
    private final transient int hashCode;

    RegularImmutableSet(Object[] objectArray, int n, Object[] objectArray2, int n2) {
        super(objectArray);
        this.table = objectArray2;
        this.mask = n2;
        this.hashCode = n;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        int n = Hashing.smear(object.hashCode());
        Object object2;
        while ((object2 = this.table[n & this.mask]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

