/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class RegularImmutableTable<R, C, V>
extends ImmutableTable<R, C, V> {
    private final ImmutableSet<Table.Cell<R, C, V>> cellSet;
    private static final Function<Table.Cell<Object, Object, Object>, Object> GET_VALUE_FUNCTION = new Function<Table.Cell<Object, Object, Object>, Object>(){

        @Override
        public Object apply(Table.Cell<Object, Object, Object> cell) {
            return cell.getValue();
        }
    };
    @Nullable
    private volatile transient ImmutableList<V> valueList;

    private RegularImmutableTable(ImmutableSet<Table.Cell<R, C, V>> immutableSet) {
        this.cellSet = immutableSet;
    }

    private Function<Table.Cell<R, C, V>, V> getValueFunction() {
        return GET_VALUE_FUNCTION;
    }

    @Override
    public final ImmutableCollection<V> values() {
        ImmutableList<V> immutableList = this.valueList;
        if (immutableList == null) {
            this.valueList = immutableList = ImmutableList.copyOf(Iterables.transform(this.cellSet(), this.getValueFunction()));
        }
        return immutableList;
    }

    @Override
    public final int size() {
        return this.cellSet().size();
    }

    @Override
    public final boolean containsValue(@Nullable Object object) {
        return ((ImmutableCollection)this.values()).contains(object);
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return this.cellSet;
    }

    static final <R, C, V> RegularImmutableTable<R, C, V> forCells(List<Table.Cell<R, C, V>> list, final @Nullable Comparator<? super R> comparator, final @Nullable Comparator<? super C> comparator2) {
        Preconditions.checkNotNull(list);
        if (comparator != null || comparator2 != null) {
            Comparator comparator3 = new Comparator<Table.Cell<R, C, V>>(){

                @Override
                public int compare(Table.Cell<R, C, V> cell, Table.Cell<R, C, V> cell2) {
                    int n;
                    int n2 = n = comparator == null ? 0 : comparator.compare(cell.getRowKey(), cell2.getRowKey());
                    if (n != 0) {
                        return n;
                    }
                    return comparator2 == null ? 0 : comparator2.compare(cell.getColumnKey(), cell2.getColumnKey());
                }
            };
            Collections.sort(list, comparator3);
        }
        return RegularImmutableTable.forCellsInternal(list, comparator, comparator2);
    }

    static final <R, C, V> RegularImmutableTable<R, C, V> forCells(Iterable<Table.Cell<R, C, V>> iterable) {
        return RegularImmutableTable.forCellsInternal(iterable, null, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final <R, C, V> RegularImmutableTable<R, C, V> forCellsInternal(Iterable<Table.Cell<R, C, V>> iterable, @Nullable Comparator<? super R> comparator, @Nullable Comparator<? super C> comparator2) {
        void var7_10;
        Collection collection;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet.Builder builder2 = ImmutableSet.builder();
        ImmutableSet.Builder builder3 = ImmutableSet.builder();
        for (Table.Cell<R, C, V> immutableSet2 : iterable) {
            builder.add(immutableSet2);
            builder2.add(immutableSet2.getRowKey());
            builder3.add(immutableSet2.getColumnKey());
        }
        ImmutableCollection immutableCollection = builder.build();
        ImmutableCollection immutableCollection2 = builder2.build();
        if (comparator != null) {
            collection = Lists.newArrayList(immutableCollection2);
            Collections.sort(collection, comparator);
            ImmutableSet immutableSet = ImmutableSet.copyOf(collection);
        }
        collection = builder3.build();
        if (comparator2 != null) {
            ArrayList arrayList = Lists.newArrayList(collection);
            Collections.sort(arrayList, comparator2);
            collection = ImmutableSet.copyOf(arrayList);
        }
        return immutableCollection.size() > var7_10.size() * collection.size() / 2 ? new DenseImmutableTable(immutableCollection, var7_10, collection) : new SparseImmutableTable(immutableCollection, var7_10, collection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    @VisibleForTesting
    static final class DenseImmutableTable<R, C, V>
    extends RegularImmutableTable<R, C, V> {
        private final ImmutableBiMap<R, Integer> rowKeyToIndex;
        private final ImmutableBiMap<C, Integer> columnKeyToIndex;
        private final V[][] values;
        private volatile transient ImmutableMap<C, Map<R, V>> columnMap;
        private volatile transient ImmutableMap<R, Map<C, V>> rowMap;

        private static <E> ImmutableBiMap<E, Integer> makeIndex(ImmutableSet<E> immutableSet) {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            int n = 0;
            for (Object e : immutableSet) {
                builder.put(e, (Object)n);
                ++n;
            }
            return builder.build();
        }

        DenseImmutableTable(ImmutableSet<Table.Cell<R, C, V>> immutableSet, ImmutableSet<R> immutableSet2, ImmutableSet<C> immutableSet3) {
            super(immutableSet);
            Object[][] objectArray = new Object[immutableSet2.size()][immutableSet3.size()];
            this.values = objectArray;
            this.rowKeyToIndex = DenseImmutableTable.makeIndex(immutableSet2);
            this.columnKeyToIndex = DenseImmutableTable.makeIndex(immutableSet3);
            for (Table.Cell cell : immutableSet) {
                int n;
                Object r = cell.getRowKey();
                Object c = cell.getColumnKey();
                int n2 = this.rowKeyToIndex.get(r);
                V v = this.values[n2][n = this.columnKeyToIndex.get(c).intValue()];
                Preconditions.checkArgument(v == null, "duplicate key: (%s, %s)", r, c);
                this.values[n2][n] = cell.getValue();
            }
        }

        @Override
        public ImmutableMap<R, V> column(C c) {
            Preconditions.checkNotNull(c);
            Integer n = this.columnKeyToIndex.get(c);
            if (n == null) {
                return ImmutableMap.of();
            }
            int n2 = n;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < this.values.length; ++i) {
                V v = this.values[i][n2];
                if (v == null) continue;
                builder.put(((ImmutableBiMap)this.rowKeyToIndex.inverse()).get(i), v);
            }
            return builder.build();
        }

        @Override
        public ImmutableSet<C> columnKeySet() {
            return this.columnKeyToIndex.keySet();
        }

        private ImmutableMap<C, Map<R, V>> makeColumnMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < this.columnKeyToIndex.size(); ++i) {
                ImmutableMap.Builder builder2 = ImmutableMap.builder();
                for (int j = 0; j < this.rowKeyToIndex.size(); ++j) {
                    V v = this.values[j][i];
                    if (v == null) continue;
                    builder2.put(((ImmutableBiMap)this.rowKeyToIndex.inverse()).get(j), v);
                }
                builder.put(((ImmutableBiMap)this.columnKeyToIndex.inverse()).get(i), builder2.build());
            }
            return builder.build();
        }

        @Override
        public ImmutableMap<C, Map<R, V>> columnMap() {
            ImmutableMap<C, Map<R, Map<R, V>>> immutableMap = this.columnMap;
            if (immutableMap == null) {
                this.columnMap = immutableMap = this.makeColumnMap();
            }
            return immutableMap;
        }

        @Override
        public boolean contains(@Nullable Object object, @Nullable Object object2) {
            return this.get(object, object2) != null;
        }

        @Override
        public boolean containsColumn(@Nullable Object object) {
            return this.columnKeyToIndex.containsKey(object);
        }

        @Override
        public boolean containsRow(@Nullable Object object) {
            return this.rowKeyToIndex.containsKey(object);
        }

        @Override
        public V get(@Nullable Object object, @Nullable Object object2) {
            Integer n = this.rowKeyToIndex.get(object);
            Integer n2 = this.columnKeyToIndex.get(object2);
            return n == null || n2 == null ? null : (V)this.values[n][n2];
        }

        @Override
        public ImmutableMap<C, V> row(R r) {
            Preconditions.checkNotNull(r);
            Integer n = this.rowKeyToIndex.get(r);
            if (n == null) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            V[] VArray = this.values[n];
            for (int i = 0; i < VArray.length; ++i) {
                V v = VArray[i];
                if (v == null) continue;
                builder.put(((ImmutableBiMap)this.columnKeyToIndex.inverse()).get(i), v);
            }
            return builder.build();
        }

        @Override
        public ImmutableSet<R> rowKeySet() {
            return this.rowKeyToIndex.keySet();
        }

        private ImmutableMap<R, Map<C, V>> makeRowMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < this.values.length; ++i) {
                V[] VArray = this.values[i];
                ImmutableMap.Builder builder2 = ImmutableMap.builder();
                for (int j = 0; j < VArray.length; ++j) {
                    V v = VArray[j];
                    if (v == null) continue;
                    builder2.put(((ImmutableBiMap)this.columnKeyToIndex.inverse()).get(j), v);
                }
                builder.put(((ImmutableBiMap)this.rowKeyToIndex.inverse()).get(i), builder2.build());
            }
            return builder.build();
        }

        @Override
        public ImmutableMap<R, Map<C, V>> rowMap() {
            ImmutableMap<R, Map<C, Map<C, V>>> immutableMap = this.rowMap;
            if (immutableMap == null) {
                this.rowMap = immutableMap = this.makeRowMap();
            }
            return immutableMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    @VisibleForTesting
    static final class SparseImmutableTable<R, C, V>
    extends RegularImmutableTable<R, C, V> {
        private final ImmutableMap<R, Map<C, V>> rowMap;
        private final ImmutableMap<C, Map<R, V>> columnMap;

        private static final <A, B, V> Map<A, ImmutableMap.Builder<B, V>> makeIndexBuilder(ImmutableSet<A> immutableSet) {
            LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
            for (Object e : immutableSet) {
                linkedHashMap.put(e, ImmutableMap.builder());
            }
            return linkedHashMap;
        }

        private static final <A, B, V> ImmutableMap<A, Map<B, V>> buildIndex(Map<A, ImmutableMap.Builder<B, V>> map) {
            return ImmutableMap.copyOf(Maps.transformValues(map, new Function<ImmutableMap.Builder<B, V>, Map<B, V>>(){

                @Override
                public Map<B, V> apply(ImmutableMap.Builder<B, V> builder) {
                    return builder.build();
                }
            }));
        }

        SparseImmutableTable(ImmutableSet<Table.Cell<R, C, V>> immutableSet, ImmutableSet<R> immutableSet2, ImmutableSet<C> immutableSet3) {
            super(immutableSet);
            Map map = SparseImmutableTable.makeIndexBuilder(immutableSet2);
            Map map2 = SparseImmutableTable.makeIndexBuilder(immutableSet3);
            for (Table.Cell cell : immutableSet) {
                Object r = cell.getRowKey();
                Object c = cell.getColumnKey();
                Object v = cell.getValue();
                map.get(r).put(c, v);
                map2.get(c).put(r, v);
            }
            this.rowMap = SparseImmutableTable.buildIndex(map);
            this.columnMap = SparseImmutableTable.buildIndex(map2);
        }

        @Override
        public ImmutableMap<R, V> column(C c) {
            Preconditions.checkNotNull(c);
            return Objects.firstNonNull((ImmutableMap)this.columnMap.get(c), ImmutableMap.of());
        }

        @Override
        public ImmutableSet<C> columnKeySet() {
            return this.columnMap.keySet();
        }

        @Override
        public ImmutableMap<C, Map<R, V>> columnMap() {
            return this.columnMap;
        }

        @Override
        public ImmutableMap<C, V> row(R r) {
            Preconditions.checkNotNull(r);
            return Objects.firstNonNull((ImmutableMap)this.rowMap.get(r), ImmutableMap.of());
        }

        @Override
        public ImmutableSet<R> rowKeySet() {
            return this.rowMap.keySet();
        }

        @Override
        public ImmutableMap<R, Map<C, V>> rowMap() {
            return this.rowMap;
        }

        @Override
        public boolean contains(@Nullable Object object, @Nullable Object object2) {
            Map<C, V> map = this.rowMap.get(object);
            return map != null && map.containsKey(object2);
        }

        @Override
        public boolean containsColumn(@Nullable Object object) {
            return this.columnMap.containsKey(object);
        }

        @Override
        public boolean containsRow(@Nullable Object object) {
            return this.rowMap.containsKey(object);
        }

        @Override
        public V get(@Nullable Object object, @Nullable Object object2) {
            Map<C, V> map = this.rowMap.get(object);
            return map == null ? null : (V)map.get(object2);
        }
    }
}

