/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
final class SingletonImmutableTable<R, C, V>
extends ImmutableTable<R, C, V> {
    private final R singleRowKey;
    private final C singleColumnKey;
    private final V singleValue;

    SingletonImmutableTable(R r, C c, V v) {
        this.singleRowKey = Preconditions.checkNotNull(r);
        this.singleColumnKey = Preconditions.checkNotNull(c);
        this.singleValue = Preconditions.checkNotNull(v);
    }

    SingletonImmutableTable(Table.Cell<R, C, V> cell) {
        this(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
    }

    @Override
    public ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return ImmutableSet.of(Tables.immutableCell(this.singleRowKey, this.singleColumnKey, this.singleValue));
    }

    @Override
    public ImmutableMap<R, V> column(C c) {
        Preconditions.checkNotNull(c);
        return this.containsColumn(c) ? ImmutableMap.of(this.singleRowKey, this.singleValue) : ImmutableMap.of();
    }

    @Override
    public ImmutableSet<C> columnKeySet() {
        return ImmutableSet.of(this.singleColumnKey);
    }

    @Override
    public ImmutableMap<C, Map<R, V>> columnMap() {
        return ImmutableMap.of(this.singleColumnKey, ImmutableMap.of(this.singleRowKey, this.singleValue));
    }

    @Override
    public boolean contains(@Nullable Object object, @Nullable Object object2) {
        return this.containsRow(object) && this.containsColumn(object2);
    }

    @Override
    public boolean containsColumn(@Nullable Object object) {
        return Objects.equal(this.singleColumnKey, object);
    }

    @Override
    public boolean containsRow(@Nullable Object object) {
        return Objects.equal(this.singleRowKey, object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return Objects.equal(this.singleValue, object);
    }

    @Override
    public V get(@Nullable Object object, @Nullable Object object2) {
        return this.contains(object, object2) ? (V)this.singleValue : null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public ImmutableMap<C, V> row(R r) {
        Preconditions.checkNotNull(r);
        return this.containsRow(r) ? ImmutableMap.of(this.singleColumnKey, this.singleValue) : ImmutableMap.of();
    }

    @Override
    public ImmutableSet<R> rowKeySet() {
        return ImmutableSet.of(this.singleRowKey);
    }

    @Override
    public ImmutableMap<R, Map<C, V>> rowMap() {
        return ImmutableMap.of(this.singleRowKey, ImmutableMap.of(this.singleColumnKey, this.singleValue));
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ImmutableCollection<V> values() {
        return ImmutableSet.of(this.singleValue);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        Table table;
        if (object == this) {
            return true;
        }
        if (object instanceof Table && (table = (Table)object).size() == 1) {
            Table.Cell cell = table.cellSet().iterator().next();
            return Objects.equal(this.singleRowKey, cell.getRowKey()) && Objects.equal(this.singleColumnKey, cell.getColumnKey()) && Objects.equal(this.singleValue, cell.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.singleRowKey, this.singleColumnKey, this.singleValue);
    }

    @Override
    public String toString() {
        return "" + '{' + this.singleRowKey + "={" + this.singleColumnKey + '=' + this.singleValue + "}}";
    }
}

