/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedIterable;
import com.google.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
final class SortedIterables {
    private SortedIterables() {
    }

    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> iterable) {
        Comparator<Object> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            comparator2 = sortedSet.comparator();
            if (comparator2 == null) {
                comparator2 = Ordering.natural();
            }
        } else {
            comparator2 = iterable instanceof SortedIterable ? ((SortedIterable)iterable).comparator() : null;
        }
        return ((Object)comparator).equals(comparator2);
    }

    public static <E> Collection<E> sortedUnique(Comparator<? super E> comparator, Iterator<E> iterator) {
        TreeSet<? super E> treeSet = Sets.newTreeSet(comparator);
        Iterators.addAll(treeSet, iterator);
        return treeSet;
    }

    public static <E> Collection<E> sortedUnique(Comparator<? super E> comparator, Iterable<E> iterable) {
        if (iterable instanceof Multiset) {
            iterable = ((Multiset)iterable).elementSet();
        }
        if (iterable instanceof Set) {
            if (SortedIterables.hasSameComparator(comparator, iterable)) {
                return (Set)iterable;
            }
            ArrayList<E> arrayList = Lists.newArrayList(iterable);
            Collections.sort(arrayList, comparator);
            return arrayList;
        }
        Object[] objectArray = Iterables.toArray(iterable);
        if (!SortedIterables.hasSameComparator(comparator, iterable)) {
            Arrays.sort(objectArray, comparator);
        }
        return SortedIterables.uniquifySortedArray(comparator, objectArray);
    }

    private static <E> Collection<E> uniquifySortedArray(Comparator<? super E> comparator, E[] EArray) {
        if (EArray.length == 0) {
            return Collections.emptySet();
        }
        int n = 1;
        for (int i = 1; i < EArray.length; ++i) {
            int n2 = comparator.compare(EArray[i], EArray[n - 1]);
            if (n2 == 0) continue;
            EArray[n++] = EArray[i];
        }
        if (n < EArray.length) {
            EArray = ObjectArrays.arraysCopyOf(EArray, n);
        }
        return Arrays.asList(EArray);
    }

    public static <E> Collection<Multiset.Entry<E>> sortedCounts(Comparator<? super E> comparator, Iterator<E> iterator) {
        TreeMultiset<E> treeMultiset = TreeMultiset.create(comparator);
        Iterators.addAll(treeMultiset, iterator);
        return treeMultiset.entrySet();
    }

    public static <E> Collection<Multiset.Entry<E>> sortedCounts(Comparator<? super E> comparator, Iterable<E> iterable) {
        if (iterable instanceof Multiset) {
            Multiset multiset = (Multiset)iterable;
            if (SortedIterables.hasSameComparator(comparator, iterable)) {
                return multiset.entrySet();
            }
            ArrayList arrayList = Lists.newArrayList(multiset.entrySet());
            Collections.sort(arrayList, Ordering.from(comparator).onResultOf(new Function<Multiset.Entry<E>, E>(){

                @Override
                public E apply(Multiset.Entry<E> entry) {
                    return entry.getElement();
                }
            }));
            return arrayList;
        }
        if (iterable instanceof Set) {
            ArrayList<E> arrayList;
            if (SortedIterables.hasSameComparator(comparator, iterable)) {
                arrayList = (ArrayList<E>)iterable;
            } else {
                ArrayList<E> arrayList2 = Lists.newArrayList(iterable);
                Collections.sort(arrayList2, comparator);
                arrayList = arrayList2;
            }
            return SortedIterables.singletonEntries(arrayList);
        }
        if (SortedIterables.hasSameComparator(comparator, iterable)) {
            Object e = null;
            int n = 0;
            ArrayList<Multiset.Entry<Multiset.Entry<Object>>> arrayList = Lists.newArrayList();
            for (E e2 : iterable) {
                if (n > 0) {
                    if (comparator.compare(e, e2) == 0) {
                        ++n;
                        continue;
                    }
                    arrayList.add(Multisets.immutableEntry(e, n));
                    e = e2;
                    n = 1;
                    continue;
                }
                e = e2;
                n = 1;
            }
            if (n > 0) {
                arrayList.add(Multisets.immutableEntry(e, n));
            }
            return arrayList;
        }
        TreeMultiset<E> treeMultiset = TreeMultiset.create(comparator);
        Iterables.addAll(treeMultiset, iterable);
        return treeMultiset.entrySet();
    }

    static <E> Collection<Multiset.Entry<E>> singletonEntries(Collection<E> collection) {
        return Collections2.transform(collection, new Function<E, Multiset.Entry<E>>(){

            @Override
            public Multiset.Entry<E> apply(E e) {
                return Multisets.immutableEntry(e, 1);
            }
        });
    }
}

