/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.StandardTable;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
class StandardRowSortedTable<R, C, V>
extends StandardTable<R, C, V>
implements RowSortedTable<R, C, V> {
    private transient SortedSet<R> rowKeySet;
    private transient RowSortedMap rowMap;
    private static final long serialVersionUID = 0L;

    StandardRowSortedTable(SortedMap<R, Map<C, V>> sortedMap, Supplier<? extends Map<C, V>> supplier) {
        super(sortedMap, supplier);
    }

    private SortedMap<R, Map<C, V>> sortedBackingMap() {
        return (SortedMap)this.backingMap;
    }

    @Override
    public SortedSet<R> rowKeySet() {
        RowKeySortedSet rowKeySortedSet = this.rowKeySet;
        return rowKeySortedSet == null ? (this.rowKeySet = new RowKeySortedSet()) : rowKeySortedSet;
    }

    @Override
    public SortedMap<R, Map<C, V>> rowMap() {
        RowSortedMap rowSortedMap = this.rowMap;
        return rowSortedMap == null ? (this.rowMap = new RowSortedMap()) : rowSortedMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowSortedMap
    extends StandardTable.RowMap
    implements SortedMap<R, Map<C, V>> {
        private RowSortedMap() {
            super(StandardRowSortedTable.this);
        }

        @Override
        public Comparator<? super R> comparator() {
            return StandardRowSortedTable.this.sortedBackingMap().comparator();
        }

        @Override
        public R firstKey() {
            return StandardRowSortedTable.this.sortedBackingMap().firstKey();
        }

        @Override
        public R lastKey() {
            return StandardRowSortedTable.this.sortedBackingMap().lastKey();
        }

        @Override
        public SortedMap<R, Map<C, V>> headMap(R r) {
            Preconditions.checkNotNull(r);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().headMap(r), StandardRowSortedTable.this.factory).rowMap();
        }

        @Override
        public SortedMap<R, Map<C, V>> subMap(R r, R r2) {
            Preconditions.checkNotNull(r);
            Preconditions.checkNotNull(r2);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().subMap(r, r2), StandardRowSortedTable.this.factory).rowMap();
        }

        @Override
        public SortedMap<R, Map<C, V>> tailMap(R r) {
            Preconditions.checkNotNull(r);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().tailMap(r), StandardRowSortedTable.this.factory).rowMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowKeySortedSet
    extends StandardTable.RowKeySet
    implements SortedSet<R> {
        private RowKeySortedSet() {
            super(StandardRowSortedTable.this);
        }

        @Override
        public Comparator<? super R> comparator() {
            return StandardRowSortedTable.this.sortedBackingMap().comparator();
        }

        @Override
        public R first() {
            return StandardRowSortedTable.this.sortedBackingMap().firstKey();
        }

        @Override
        public R last() {
            return StandardRowSortedTable.this.sortedBackingMap().lastKey();
        }

        @Override
        public SortedSet<R> headSet(R r) {
            Preconditions.checkNotNull(r);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().headMap(r), StandardRowSortedTable.this.factory).rowKeySet();
        }

        @Override
        public SortedSet<R> subSet(R r, R r2) {
            Preconditions.checkNotNull(r);
            Preconditions.checkNotNull(r2);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().subMap(r, r2), StandardRowSortedTable.this.factory).rowKeySet();
        }

        @Override
        public SortedSet<R> tailSet(R r) {
            Preconditions.checkNotNull(r);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().tailMap(r), StandardRowSortedTable.this.factory).rowKeySet();
        }
    }
}

