/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.StandardTable;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@Beta
public final class Tables {
    private static final Function<? extends Map<?, ?>, ? extends Map<?, ?>> UNMODIFIABLE_WRAPPER = new Function<Map<Object, Object>, Map<Object, Object>>(){

        @Override
        public Map<Object, Object> apply(Map<Object, Object> map) {
            return Collections.unmodifiableMap(map);
        }
    };

    private Tables() {
    }

    public static <R, C, V> Table.Cell<R, C, V> immutableCell(@Nullable R r, @Nullable C c, @Nullable V v) {
        return new ImmutableCell<R, C, V>(r, c, v);
    }

    public static <R, C, V> Table<C, R, V> transpose(Table<R, C, V> table) {
        return table instanceof TransposeTable ? ((TransposeTable)table).original : new TransposeTable<C, R, V>(table);
    }

    public static <R, C, V> Table<R, C, V> newCustomTable(Map<R, Map<C, V>> map, Supplier<? extends Map<C, V>> supplier) {
        Preconditions.checkArgument(map.isEmpty());
        Preconditions.checkNotNull(supplier);
        return new StandardTable<R, C, V>(map, supplier);
    }

    public static <R, C, V1, V2> Table<R, C, V2> transformValues(Table<R, C, V1> table, Function<? super V1, V2> function) {
        return new TransformedTable<R, C, V1, V2>(table, function);
    }

    public static <R, C, V> Table<R, C, V> unmodifiableTable(Table<? extends R, ? extends C, ? extends V> table) {
        return new UnmodifiableTable<R, C, V>(table);
    }

    public static <R, C, V> RowSortedTable<R, C, V> unmodifiableRowSortedTable(RowSortedTable<R, ? extends C, ? extends V> rowSortedTable) {
        return new UnmodifiableRowSortedMap<R, C, V>(rowSortedTable);
    }

    private static <K, V> Function<Map<K, V>, Map<K, V>> unmodifiableWrapper() {
        return UNMODIFIABLE_WRAPPER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnmodifiableRowSortedMap<R, C, V>
    extends UnmodifiableTable<R, C, V>
    implements RowSortedTable<R, C, V> {
        private static final long serialVersionUID = 0L;

        public UnmodifiableRowSortedMap(RowSortedTable<R, ? extends C, ? extends V> rowSortedTable) {
            super(rowSortedTable);
        }

        @Override
        protected RowSortedTable<R, C, V> delegate() {
            return (RowSortedTable)super.delegate();
        }

        @Override
        public SortedMap<R, Map<C, V>> rowMap() {
            Function function = Tables.unmodifiableWrapper();
            return Collections.unmodifiableSortedMap(Maps.transformValues(this.delegate().rowMap(), function));
        }

        @Override
        public SortedSet<R> rowKeySet() {
            return Collections.unmodifiableSortedSet(this.delegate().rowKeySet());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableTable<R, C, V>
    extends ForwardingTable<R, C, V>
    implements Serializable {
        final Table<? extends R, ? extends C, ? extends V> delegate;
        private static final long serialVersionUID = 0L;

        UnmodifiableTable(Table<? extends R, ? extends C, ? extends V> table) {
            this.delegate = Preconditions.checkNotNull(table);
        }

        @Override
        protected Table<R, C, V> delegate() {
            return this.delegate;
        }

        @Override
        public Set<Table.Cell<R, C, V>> cellSet() {
            return Collections.unmodifiableSet(super.cellSet());
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<R, V> column(@Nullable C c) {
            return Collections.unmodifiableMap(super.column(c));
        }

        @Override
        public Set<C> columnKeySet() {
            return Collections.unmodifiableSet(super.columnKeySet());
        }

        @Override
        public Map<C, Map<R, V>> columnMap() {
            Function function = Tables.unmodifiableWrapper();
            return Collections.unmodifiableMap(Maps.transformValues(super.columnMap(), function));
        }

        @Override
        public V put(@Nullable R r, @Nullable C c, @Nullable V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(@Nullable Object object, @Nullable Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<C, V> row(@Nullable R r) {
            return Collections.unmodifiableMap(super.row(r));
        }

        @Override
        public Set<R> rowKeySet() {
            return Collections.unmodifiableSet(super.rowKeySet());
        }

        @Override
        public Map<R, Map<C, V>> rowMap() {
            Function function = Tables.unmodifiableWrapper();
            return Collections.unmodifiableMap(Maps.transformValues(super.rowMap(), function));
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(super.values());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformedTable<R, C, V1, V2>
    implements Table<R, C, V2> {
        final Table<R, C, V1> fromTable;
        final Function<? super V1, V2> function;
        CellSet cellSet;
        Collection<V2> values;
        Map<R, Map<C, V2>> rowMap;
        Map<C, Map<R, V2>> columnMap;

        TransformedTable(Table<R, C, V1> table, Function<? super V1, V2> function) {
            this.fromTable = Preconditions.checkNotNull(table);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean contains(Object object, Object object2) {
            return this.fromTable.contains(object, object2);
        }

        @Override
        public boolean containsRow(Object object) {
            return this.fromTable.containsRow(object);
        }

        @Override
        public boolean containsColumn(Object object) {
            return this.fromTable.containsColumn(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.values().contains(object);
        }

        @Override
        public V2 get(Object object, Object object2) {
            return this.contains(object, object2) ? (V2)this.function.apply((V1)this.fromTable.get(object, object2)) : null;
        }

        @Override
        public boolean isEmpty() {
            return this.fromTable.isEmpty();
        }

        @Override
        public int size() {
            return this.fromTable.size();
        }

        @Override
        public void clear() {
            this.fromTable.clear();
        }

        @Override
        public V2 put(R r, C c, V2 V2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Table<? extends R, ? extends C, ? extends V2> table) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V2 remove(Object object, Object object2) {
            return this.contains(object, object2) ? (V2)this.function.apply((V1)this.fromTable.remove(object, object2)) : null;
        }

        @Override
        public Map<C, V2> row(R r) {
            return Maps.transformValues(this.fromTable.row(r), this.function);
        }

        @Override
        public Map<R, V2> column(C c) {
            return Maps.transformValues(this.fromTable.column(c), this.function);
        }

        Function<Table.Cell<R, C, V1>, Table.Cell<R, C, V2>> cellFunction() {
            return new Function<Table.Cell<R, C, V1>, Table.Cell<R, C, V2>>(){

                @Override
                public Table.Cell<R, C, V2> apply(Table.Cell<R, C, V1> cell) {
                    return Tables.immutableCell(cell.getRowKey(), cell.getColumnKey(), TransformedTable.this.function.apply(cell.getValue()));
                }
            };
        }

        @Override
        public Set<Table.Cell<R, C, V2>> cellSet() {
            return this.cellSet == null ? (this.cellSet = new CellSet()) : this.cellSet;
        }

        @Override
        public Set<R> rowKeySet() {
            return this.fromTable.rowKeySet();
        }

        @Override
        public Set<C> columnKeySet() {
            return this.fromTable.columnKeySet();
        }

        @Override
        public Collection<V2> values() {
            return this.values == null ? (this.values = Collections2.transform(this.fromTable.values(), this.function)) : this.values;
        }

        Map<R, Map<C, V2>> createRowMap() {
            Function function = new Function<Map<C, V1>, Map<C, V2>>(){

                @Override
                public Map<C, V2> apply(Map<C, V1> map) {
                    return Maps.transformValues(map, TransformedTable.this.function);
                }
            };
            return Maps.transformValues(this.fromTable.rowMap(), function);
        }

        @Override
        public Map<R, Map<C, V2>> rowMap() {
            return this.rowMap == null ? (this.rowMap = this.createRowMap()) : this.rowMap;
        }

        Map<C, Map<R, V2>> createColumnMap() {
            Function function = new Function<Map<R, V1>, Map<R, V2>>(){

                @Override
                public Map<R, V2> apply(Map<R, V1> map) {
                    return Maps.transformValues(map, TransformedTable.this.function);
                }
            };
            return Maps.transformValues(this.fromTable.columnMap(), function);
        }

        @Override
        public Map<C, Map<R, V2>> columnMap() {
            return this.columnMap == null ? (this.columnMap = this.createColumnMap()) : this.columnMap;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Table) {
                Table table = (Table)object;
                return ((Object)this.cellSet()).equals(table.cellSet());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.cellSet()).hashCode();
        }

        public String toString() {
            return this.rowMap().toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CellSet
        extends Collections2.TransformedCollection<Table.Cell<R, C, V1>, Table.Cell<R, C, V2>>
        implements Set<Table.Cell<R, C, V2>> {
            CellSet() {
                super(TransformedTable.this.fromTable.cellSet(), TransformedTable.this.cellFunction());
            }

            @Override
            public boolean equals(Object object) {
                return Sets.equalsImpl(this, object);
            }

            @Override
            public int hashCode() {
                return Sets.hashCodeImpl(this);
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Table.Cell) {
                    Table.Cell cell = (Table.Cell)object;
                    if (!Objects.equal(cell.getValue(), TransformedTable.this.get(cell.getRowKey(), cell.getColumnKey()))) {
                        return false;
                    }
                    return cell.getValue() != null || TransformedTable.this.fromTable.contains(cell.getRowKey(), cell.getColumnKey());
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    Table.Cell cell = (Table.Cell)object;
                    TransformedTable.this.fromTable.remove(cell.getRowKey(), cell.getColumnKey());
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransposeTable<C, R, V>
    implements Table<C, R, V> {
        final Table<R, C, V> original;
        private static final Function<Table.Cell<?, ?, ?>, Table.Cell<?, ?, ?>> TRANSPOSE_CELL = new Function<Table.Cell<?, ?, ?>, Table.Cell<?, ?, ?>>(){

            @Override
            public Table.Cell<?, ?, ?> apply(Table.Cell<?, ?, ?> cell) {
                return Tables.immutableCell(cell.getColumnKey(), cell.getRowKey(), cell.getValue());
            }
        };
        CellSet cellSet;

        TransposeTable(Table<R, C, V> table) {
            this.original = Preconditions.checkNotNull(table);
        }

        @Override
        public void clear() {
            this.original.clear();
        }

        @Override
        public Map<C, V> column(R r) {
            return this.original.row(r);
        }

        @Override
        public Set<R> columnKeySet() {
            return this.original.rowKeySet();
        }

        @Override
        public Map<R, Map<C, V>> columnMap() {
            return this.original.rowMap();
        }

        @Override
        public boolean contains(@Nullable Object object, @Nullable Object object2) {
            return this.original.contains(object2, object);
        }

        @Override
        public boolean containsColumn(@Nullable Object object) {
            return this.original.containsRow(object);
        }

        @Override
        public boolean containsRow(@Nullable Object object) {
            return this.original.containsColumn(object);
        }

        @Override
        public boolean containsValue(@Nullable Object object) {
            return this.original.containsValue(object);
        }

        @Override
        public V get(@Nullable Object object, @Nullable Object object2) {
            return this.original.get(object2, object);
        }

        @Override
        public boolean isEmpty() {
            return this.original.isEmpty();
        }

        @Override
        public V put(C c, R r, V v) {
            return this.original.put(r, c, v);
        }

        @Override
        public void putAll(Table<? extends C, ? extends R, ? extends V> table) {
            this.original.putAll(Tables.transpose(table));
        }

        @Override
        public V remove(@Nullable Object object, @Nullable Object object2) {
            return this.original.remove(object2, object);
        }

        @Override
        public Map<R, V> row(C c) {
            return this.original.column(c);
        }

        @Override
        public Set<C> rowKeySet() {
            return this.original.columnKeySet();
        }

        @Override
        public Map<C, Map<R, V>> rowMap() {
            return this.original.columnMap();
        }

        @Override
        public int size() {
            return this.original.size();
        }

        @Override
        public Collection<V> values() {
            return this.original.values();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Table) {
                Table table = (Table)object;
                return ((Object)this.cellSet()).equals(table.cellSet());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.cellSet()).hashCode();
        }

        public String toString() {
            return this.rowMap().toString();
        }

        @Override
        public Set<Table.Cell<C, R, V>> cellSet() {
            CellSet cellSet = this.cellSet;
            return cellSet == null ? (this.cellSet = new CellSet()) : cellSet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CellSet
        extends Collections2.TransformedCollection<Table.Cell<R, C, V>, Table.Cell<C, R, V>>
        implements Set<Table.Cell<C, R, V>> {
            CellSet() {
                super(TransposeTable.this.original.cellSet(), TRANSPOSE_CELL);
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                if (set.size() != this.size()) {
                    return false;
                }
                return this.containsAll(set);
            }

            @Override
            public int hashCode() {
                return Sets.hashCodeImpl(this);
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Table.Cell) {
                    Table.Cell cell = (Table.Cell)object;
                    return TransposeTable.this.original.cellSet().contains(Tables.immutableCell(cell.getColumnKey(), cell.getRowKey(), cell.getValue()));
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                if (object instanceof Table.Cell) {
                    Table.Cell cell = (Table.Cell)object;
                    return TransposeTable.this.original.cellSet().remove(Tables.immutableCell(cell.getColumnKey(), cell.getRowKey(), cell.getValue()));
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractCell<R, C, V>
    implements Table.Cell<R, C, V> {
        AbstractCell() {
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)object;
                return Objects.equal(this.getRowKey(), cell.getRowKey()) && Objects.equal(this.getColumnKey(), cell.getColumnKey()) && Objects.equal(this.getValue(), cell.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getRowKey(), this.getColumnKey(), this.getValue());
        }

        public String toString() {
            return "(" + this.getRowKey() + "," + this.getColumnKey() + ")=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ImmutableCell<R, C, V>
    extends AbstractCell<R, C, V>
    implements Serializable {
        private final R rowKey;
        private final C columnKey;
        private final V value;
        private static final long serialVersionUID = 0L;

        ImmutableCell(@Nullable R r, @Nullable C c, @Nullable V v) {
            this.rowKey = r;
            this.columnKey = c;
            this.value = v;
        }

        @Override
        public R getRowKey() {
            return this.rowKey;
        }

        @Override
        public C getColumnKey() {
            return this.columnKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }
}

