/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
final class WellBehavedMap<K, V>
extends ForwardingMap<K, V> {
    private final Map<K, V> delegate;
    private Set<Map.Entry<K, V>> entrySet;

    private WellBehavedMap(Map<K, V> map) {
        this.delegate = map;
    }

    static <K, V> WellBehavedMap<K, V> wrap(Map<K, V> map) {
        return new WellBehavedMap<K, V>(map);
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = Sets.transform(this.delegate.keySet(), new KeyToEntryConverter(this));
        return this.entrySet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyToEntryConverter<K, V>
    extends Sets.InvertibleFunction<K, Map.Entry<K, V>> {
        final Map<K, V> map;

        KeyToEntryConverter(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public Map.Entry<K, V> apply(final K k) {
            return new AbstractMapEntry<K, V>(){

                @Override
                public K getKey() {
                    return k;
                }

                @Override
                public V getValue() {
                    return KeyToEntryConverter.this.map.get(k);
                }

                @Override
                public V setValue(V v) {
                    return KeyToEntryConverter.this.map.put(k, v);
                }
            };
        }

        @Override
        public K invert(Map.Entry<K, V> entry) {
            return entry.getKey();
        }
    }
}

