/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventHandler;
import com.google.common.eventbus.HandlerFindingStrategy;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SynchronizedEventHandler;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap<Class<?>, EventHandler> findAllHandlers(Object object) {
        HashMultimap<Class<?>, EventHandler> hashMultimap = HashMultimap.create();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getMethods()) {
                Subscribe subscribe = method.getAnnotation(Subscribe.class);
                if (subscribe == null) continue;
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but requires " + classArray.length + " arguments.  Event handler methods " + "must require a single argument.");
                }
                Class<?> clazz2 = classArray[0];
                EventHandler eventHandler = AnnotatedHandlerFinder.makeHandler(object, method);
                hashMultimap.put(clazz2, eventHandler);
            }
        }
        return hashMultimap;
    }

    private static EventHandler makeHandler(Object object, Method method) {
        EventHandler eventHandler = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(object, method) : new SynchronizedEventHandler(object, method);
        return eventHandler;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }
}

