/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.annotations.Beta;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.EventHandler;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

@Beta
public class AsyncEventBus
extends EventBus {
    private final Executor executor;
    private final ConcurrentLinkedQueue<EventBus.EventWithHandler> eventsToDispatch = new ConcurrentLinkedQueue();

    public AsyncEventBus(String string, Executor executor) {
        super(string);
        this.executor = executor;
    }

    public AsyncEventBus(Executor executor) {
        this.executor = executor;
    }

    protected void enqueueEvent(Object object, EventHandler eventHandler) {
        this.eventsToDispatch.offer(new EventBus.EventWithHandler(object, eventHandler));
    }

    protected void dispatchQueuedEvents() {
        EventBus.EventWithHandler eventWithHandler;
        while ((eventWithHandler = this.eventsToDispatch.poll()) != null) {
            this.dispatch(eventWithHandler.event, eventWithHandler.handler);
        }
    }

    protected void dispatch(final Object object, final EventHandler eventHandler) {
        this.executor.execute(new Runnable(){

            public void run() {
                AsyncEventBus.super.dispatch(object, eventHandler);
            }
        });
    }
}

