/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilterStrategies;
import com.google.common.hash.Funnel;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class BloomFilter<T>
implements Serializable {
    private final BloomFilterStrategies.BitArray bits;
    private final int numHashFunctions;
    private final Funnel<T> funnel;
    private final Strategy strategy;
    private static final double LN2 = Math.log(2.0);
    private static final double LN2_SQUARED = LN2 * LN2;

    private BloomFilter(BloomFilterStrategies.BitArray bitArray, int n, Funnel<T> funnel, Strategy strategy) {
        Preconditions.checkArgument(n > 0, "numHashFunctions zero or negative");
        this.bits = Preconditions.checkNotNull(bitArray);
        this.numHashFunctions = n;
        this.funnel = Preconditions.checkNotNull(funnel);
        this.strategy = strategy;
    }

    public boolean mightContain(T t) {
        return this.strategy.mightContain(t, this.funnel, this.numHashFunctions, this.bits);
    }

    public void put(T t) {
        this.strategy.put(t, this.funnel, this.numHashFunctions, this.bits);
    }

    @VisibleForTesting
    int getHashCount() {
        return this.numHashFunctions;
    }

    @VisibleForTesting
    double computeExpectedFalsePositiveRate(int n) {
        return Math.pow(1.0 - Math.exp((double)(-this.numHashFunctions) * ((double)n / (double)this.bits.size())), this.numHashFunctions);
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int n, double d) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument(n > 0, "Expected insertions must be positive");
        Preconditions.checkArgument(d > 0.0 & d < 1.0, "False positive probability in (0.0, 1.0)");
        int n2 = BloomFilter.optimalNumOfBits(n, d);
        int n3 = BloomFilter.optimalNumOfHashFunctions(n, n2);
        return new BloomFilter<T>(new BloomFilterStrategies.BitArray(n2), n3, funnel, BloomFilterStrategies.MURMUR128_MITZ_32);
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int n) {
        return BloomFilter.create(funnel, n, 0.03);
    }

    @VisibleForTesting
    static int optimalNumOfHashFunctions(int n, int n2) {
        return Math.max(1, (int)Math.round((double)(n2 / n) * LN2));
    }

    @VisibleForTesting
    static int optimalNumOfBits(int n, double d) {
        return (int)((double)(-n) * Math.log(d) / LN2_SQUARED);
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerialForm<T>
    implements Serializable {
        final long[] data;
        final int numHashFunctions;
        final Funnel<T> funnel;
        final Strategy strategy;
        private static final long serialVersionUID = 1L;

        SerialForm(BloomFilter<T> bloomFilter) {
            this.data = ((BloomFilter)bloomFilter).bits.data;
            this.numHashFunctions = ((BloomFilter)bloomFilter).numHashFunctions;
            this.funnel = ((BloomFilter)bloomFilter).funnel;
            this.strategy = ((BloomFilter)bloomFilter).strategy;
        }

        Object readResolve() {
            return new BloomFilter(new BloomFilterStrategies.BitArray(this.data), this.numHashFunctions, this.funnel, this.strategy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Strategy
    extends Serializable {
        public <T> void put(T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.BitArray var4);

        public <T> boolean mightContain(T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.BitArray var4);
    }
}

