/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import com.google.common.math.IntMath;
import java.math.RoundingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum BloomFilterStrategies implements BloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public <T> void put(T t, Funnel<? super T> funnel, int n, BitArray bitArray) {
            long l = Hashing.murmur3_128().newHasher().putObject(t, funnel).hash().asLong();
            int n2 = (int)l;
            int n3 = (int)(l >>> 32);
            for (int i = 1; i <= n; ++i) {
                int n4 = n2 + i * n3;
                if (n4 < 0) {
                    n4 ^= 0xFFFFFFFF;
                }
                bitArray.set(n4 % bitArray.size());
            }
        }

        @Override
        public <T> boolean mightContain(T t, Funnel<? super T> funnel, int n, BitArray bitArray) {
            long l = Hashing.murmur3_128().newHasher().putObject(t, funnel).hash().asLong();
            int n2 = (int)l;
            int n3 = (int)(l >>> 32);
            for (int i = 1; i <= n; ++i) {
                int n4 = n2 + i * n3;
                if (n4 < 0) {
                    n4 ^= 0xFFFFFFFF;
                }
                if (bitArray.get(n4 % bitArray.size())) continue;
                return false;
            }
            return true;
        }
    };


    static class BitArray {
        final long[] data;

        BitArray(int n) {
            this(new long[IntMath.divide(n, 64, RoundingMode.CEILING)]);
        }

        BitArray(long[] lArray) {
            Preconditions.checkArgument(lArray.length > 0, "data length is zero!");
            this.data = lArray;
        }

        void set(int n) {
            int n2 = n >> 6;
            this.data[n2] = this.data[n2] | 1L << n;
        }

        boolean get(int n) {
            return (this.data[n >> 6] & 1L << n) != 0L;
        }

        int size() {
            return this.data.length * 64;
        }
    }
}

