/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashCodes;
import com.google.common.hash.Hasher;
import com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.nio.ByteBuffer;

final class Murmur3_32HashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_32HashFunction(int n) {
        this.seed = n;
    }

    public int bits() {
        return 32;
    }

    public Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    private static final class Murmur3_32Hasher
    extends AbstractStreamingHashFunction.AbstractStreamingHasher {
        int h1;
        int c1 = -862048943;
        int c2 = 461845907;
        int len;

        Murmur3_32Hasher(int n) {
            super(4);
            this.h1 = n;
        }

        protected void process(ByteBuffer byteBuffer) {
            int n = byteBuffer.getInt();
            this.len += 4;
            n *= this.c1;
            n = Integer.rotateLeft(n, 15);
            this.h1 ^= (n *= this.c2);
            this.h1 = Integer.rotateLeft(this.h1, 13);
            this.h1 = this.h1 * 5 + -430675100;
        }

        protected void processRemaining(ByteBuffer byteBuffer) {
            this.len += byteBuffer.remaining();
            int n = 0;
            switch (byteBuffer.remaining()) {
                case 3: {
                    n ^= UnsignedBytes.toInt(byteBuffer.get(2)) << 16;
                }
                case 2: {
                    n ^= UnsignedBytes.toInt(byteBuffer.get(1)) << 8;
                }
                case 1: {
                    n ^= UnsignedBytes.toInt(byteBuffer.get(0));
                }
            }
            n *= this.c1;
            n = Integer.rotateLeft(n, 15);
            this.h1 ^= (n *= this.c2);
        }

        public HashCode makeHash() {
            this.h1 ^= this.len;
            this.h1 ^= this.h1 >>> 16;
            this.h1 *= -2048144789;
            this.h1 ^= this.h1 >>> 13;
            this.h1 *= -1028477387;
            this.h1 ^= this.h1 >>> 16;
            return HashCodes.fromInt(this.h1);
        }
    }
}

