/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Beta
@Immutable
public final class HostAndPort {
    private static final int NO_PORT = -1;
    private final String host;
    private final int port;
    private final boolean hasBracketlessColons;
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::(\\d*))?$");

    private HostAndPort(String string, int n, boolean bl) {
        this.host = string;
        this.port = n;
        this.hasBracketlessColons = bl;
    }

    public String getHostText() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public int getPort() {
        Preconditions.checkState(this.hasPort());
        return this.port;
    }

    public int getPortOrDefault(int n) {
        return this.hasPort() ? this.port : n;
    }

    public static HostAndPort fromParts(String string, int n) {
        Preconditions.checkArgument(HostAndPort.isValidPort(n));
        HostAndPort hostAndPort = HostAndPort.fromString(string);
        Preconditions.checkArgument(!hostAndPort.hasPort());
        return new HostAndPort(hostAndPort.host, n, hostAndPort.hasBracketlessColons);
    }

    public static HostAndPort fromString(String string) {
        String string2;
        Preconditions.checkNotNull(string);
        String string3 = null;
        boolean bl = false;
        if (string.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(string);
            Preconditions.checkArgument(matcher.matches(), "Invalid bracketed host/port: %s", string);
            string2 = matcher.group(1);
            string3 = matcher.group(2);
        } else {
            int n = string.indexOf(58);
            if (n >= 0 && string.indexOf(58, n + 1) == -1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            } else {
                string2 = string;
                bl = n >= 0;
            }
        }
        int n = -1;
        if (string3 != null) {
            Preconditions.checkArgument(!string3.startsWith("+"), "Unparseable port number: %s", string);
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Unparseable port number: " + string);
            }
            Preconditions.checkArgument(HostAndPort.isValidPort(n), "Port number out of range: %s", string);
        }
        return new HostAndPort(string2, n, bl);
    }

    public HostAndPort withDefaultPort(int n) {
        Preconditions.checkArgument(HostAndPort.isValidPort(n));
        if (this.hasPort() || this.port == n) {
            return this;
        }
        return new HostAndPort(this.host, n, this.hasBracketlessColons);
    }

    public HostAndPort requireBracketsForIPv6() {
        Preconditions.checkArgument(!this.hasBracketlessColons, "Possible bracketless IPv6 literal: %s", this.host);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HostAndPort) {
            HostAndPort hostAndPort = (HostAndPort)object;
            return Objects.equal(this.host, hostAndPort.host) && this.port == hostAndPort.port && this.hasBracketlessColons == hostAndPort.hasBracketlessColons;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.host, this.port, this.hasBracketlessColons);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.host.length() + 7);
        if (this.host.indexOf(58) >= 0) {
            stringBuilder.append('[').append(this.host).append(']');
        } else {
            stringBuilder.append(this.host);
        }
        if (this.hasPort()) {
            stringBuilder.append(':').append(this.port);
        }
        return stringBuilder.toString();
    }

    private static boolean isValidPort(int n) {
        return n >= 0 && n <= 65535;
    }
}

