/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;

final class AndroidInteger {
    @CheckForNull
    static Integer tryParse(String string) {
        return AndroidInteger.tryParse(string, 10);
    }

    @CheckForNull
    static Integer tryParse(String string, int n) {
        boolean bl;
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(n >= 2, "Invalid radix %s, min radix is %s", n, 2);
        Preconditions.checkArgument(n <= 36, "Invalid radix %s, max radix is %s", n, 36);
        int n2 = string.length();
        int n3 = 0;
        if (n2 == 0) {
            return null;
        }
        boolean bl2 = bl = string.charAt(n3) == '-';
        if (bl && ++n3 == n2) {
            return null;
        }
        return AndroidInteger.tryParse(string, n3, n, bl);
    }

    @CheckForNull
    private static Integer tryParse(String string, int n, int n2, boolean bl) {
        int n3 = Integer.MIN_VALUE / n2;
        int n4 = 0;
        int n5 = string.length();
        while (n < n5) {
            int n6;
            if ((n6 = Character.digit(string.charAt(n++), n2)) == -1) {
                return null;
            }
            if (n3 > n4) {
                return null;
            }
            int n7 = n4 * n2 - n6;
            if (n7 > n4) {
                return null;
            }
            n4 = n7;
        }
        if (!bl && (n4 = -n4) < 0) {
            return null;
        }
        if (n4 > Integer.MAX_VALUE || n4 < Integer.MIN_VALUE) {
            return null;
        }
        return n4;
    }

    private AndroidInteger() {
    }
}

