/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Beta
public final class Monitor {
    private final boolean fair;
    private final ReentrantLock lock;
    @GuardedBy(value="lock")
    private final ArrayList<Guard> activeGuards = Lists.newArrayListWithCapacity(1);

    public Monitor() {
        this(false);
    }

    public Monitor(boolean bl) {
        this.fair = bl;
        this.lock = new ReentrantLock(bl);
    }

    public void enter() {
        this.lock.lock();
    }

    public void enterInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    public boolean enter(long l, TimeUnit timeUnit) {
        long l2;
        ReentrantLock reentrantLock = this.lock;
        if (!this.fair && reentrantLock.tryLock()) {
            return true;
        }
        long l3 = System.nanoTime();
        long l4 = l2 = timeUnit.toNanos(l);
        boolean bl = false;
        while (true) {
            try {
                boolean bl2 = reentrantLock.tryLock(l4, TimeUnit.NANOSECONDS);
                return bl2;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                l4 = l2 - (System.nanoTime() - l3);
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean enterInterruptibly(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.lock.tryLock(l, timeUnit);
    }

    public boolean tryEnter() {
        return this.lock.tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterWhen(Guard guard) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl = reentrantLock.isHeldByCurrentThread();
        boolean bl2 = false;
        reentrantLock.lockInterruptibly();
        try {
            this.waitInterruptibly(guard, bl);
            bl2 = true;
        }
        finally {
            if (!bl2) {
                reentrantLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterWhenUninterruptibly(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl = reentrantLock.isHeldByCurrentThread();
        boolean bl2 = false;
        reentrantLock.lock();
        try {
            this.waitUninterruptibly(guard, bl);
            bl2 = true;
        }
        finally {
            if (!bl2) {
                reentrantLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterWhen(Guard guard, long l, TimeUnit timeUnit) throws InterruptedException {
        long l2;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl = reentrantLock.isHeldByCurrentThread();
        if (!this.fair && reentrantLock.tryLock()) {
            l2 = timeUnit.toNanos(l);
        } else {
            long l3 = System.nanoTime();
            if (!reentrantLock.tryLock(l, timeUnit)) {
                return false;
            }
            l2 = timeUnit.toNanos(l) - (System.nanoTime() - l3);
        }
        boolean bl2 = false;
        try {
            bl2 = this.waitInterruptibly(guard, l2, bl);
        }
        finally {
            if (!bl2) {
                reentrantLock.unlock();
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterWhenUninterruptibly(Guard guard, long l, TimeUnit timeUnit) {
        long l2;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl = reentrantLock.isHeldByCurrentThread();
        boolean bl2 = false;
        if (!this.fair && reentrantLock.tryLock()) {
            l2 = timeUnit.toNanos(l);
        } else {
            long l3;
            long l4 = System.nanoTime();
            l2 = l3 = timeUnit.toNanos(l);
            while (true) {
                try {
                    if (reentrantLock.tryLock(l2, TimeUnit.NANOSECONDS)) break;
                    boolean bl3 = false;
                    return bl3;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    continue;
                }
                finally {
                    l2 = l3 - (System.nanoTime() - l4);
                    continue;
                }
                break;
            }
        }
        boolean bl4 = false;
        try {
            bl4 = this.waitUninterruptibly(guard, l2, bl);
        }
        finally {
            if (!bl4) {
                reentrantLock.unlock();
            }
        }
        boolean bl5 = bl4;
        return bl5;
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterIf(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        boolean bl = false;
        try {
            bl = guard.isSatisfied();
        }
        finally {
            if (!bl) {
                reentrantLock.unlock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterIfInterruptibly(Guard guard) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        boolean bl = false;
        try {
            bl = guard.isSatisfied();
        }
        finally {
            if (!bl) {
                reentrantLock.unlock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterIf(Guard guard, long l, TimeUnit timeUnit) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        if (!this.enter(l, timeUnit)) {
            return false;
        }
        boolean bl = false;
        try {
            bl = guard.isSatisfied();
        }
        finally {
            if (!bl) {
                reentrantLock.unlock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterIfInterruptibly(Guard guard, long l, TimeUnit timeUnit) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        if (!reentrantLock.tryLock(l, timeUnit)) {
            return false;
        }
        boolean bl = false;
        try {
            bl = guard.isSatisfied();
        }
        finally {
            if (!bl) {
                reentrantLock.unlock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryEnterIf(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        if (!reentrantLock.tryLock()) {
            return false;
        }
        boolean bl = false;
        try {
            bl = guard.isSatisfied();
        }
        finally {
            if (!bl) {
                reentrantLock.unlock();
            }
        }
        return bl;
    }

    public void waitFor(Guard guard) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.waitInterruptibly(guard, true);
    }

    public void waitForUninterruptibly(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.waitUninterruptibly(guard, true);
    }

    public boolean waitFor(Guard guard, long l, TimeUnit timeUnit) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.waitInterruptibly(guard, timeUnit.toNanos(l), true);
    }

    public boolean waitForUninterruptibly(Guard guard, long l, TimeUnit timeUnit) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.waitUninterruptibly(guard, timeUnit.toNanos(l), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave() {
        ReentrantLock reentrantLock = this.lock;
        if (!reentrantLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        try {
            this.signalConditionsOfSatisfiedGuards(null);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean isFair() {
        return this.lock.isFair();
    }

    public boolean isOccupied() {
        return this.lock.isLocked();
    }

    public boolean isOccupiedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public int getOccupiedDepth() {
        return this.lock.getHoldCount();
    }

    public int getQueueLength() {
        return this.lock.getQueueLength();
    }

    public boolean hasQueuedThreads() {
        return this.lock.hasQueuedThreads();
    }

    public boolean hasQueuedThread(Thread thread) {
        return this.lock.hasQueuedThread(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWaiters(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        this.lock.lock();
        try {
            boolean bl = guard.waiterCount > 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitQueueLength(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        this.lock.lock();
        try {
            int n = guard.waiterCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void signalConditionsOfSatisfiedGuards(@Nullable Guard guard) {
        ArrayList<Guard> arrayList = this.activeGuards;
        int n = arrayList.size();
        try {
            for (int i = 0; i < n; ++i) {
                Guard guard2 = arrayList.get(i);
                if (guard2 == guard && guard2.waiterCount == 1 || !guard2.isSatisfied()) continue;
                guard2.condition.signal();
                return;
            }
        }
        catch (Throwable throwable) {
            for (int i = 0; i < n; ++i) {
                Guard guard3 = arrayList.get(i);
                guard3.condition.signalAll();
            }
            throw Throwables.propagate(throwable);
        }
    }

    @GuardedBy(value="lock")
    private void incrementWaiters(Guard guard) {
        int n;
        if ((n = guard.waiterCount++) == 0) {
            this.activeGuards.add(guard);
        }
    }

    @GuardedBy(value="lock")
    private void decrementWaiters(Guard guard) {
        int n;
        if ((n = --guard.waiterCount) == 0) {
            this.activeGuards.remove(guard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private void waitInterruptibly(Guard guard, boolean bl) throws InterruptedException {
        if (!guard.isSatisfied()) {
            if (bl) {
                this.signalConditionsOfSatisfiedGuards(null);
            }
            this.incrementWaiters(guard);
            try {
                Condition condition = guard.condition;
                do {
                    try {
                        condition.await();
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            this.signalConditionsOfSatisfiedGuards(guard);
                        }
                        catch (Throwable throwable) {
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate(throwable);
                        }
                        throw interruptedException;
                    }
                } while (!guard.isSatisfied());
            }
            finally {
                this.decrementWaiters(guard);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private void waitUninterruptibly(Guard guard, boolean bl) {
        if (!guard.isSatisfied()) {
            if (bl) {
                this.signalConditionsOfSatisfiedGuards(null);
            }
            this.incrementWaiters(guard);
            try {
                Condition condition = guard.condition;
                do {
                    condition.awaitUninterruptibly();
                } while (!guard.isSatisfied());
            }
            finally {
                this.decrementWaiters(guard);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private boolean waitInterruptibly(Guard guard, long l, boolean bl) throws InterruptedException {
        if (!guard.isSatisfied()) {
            if (bl) {
                this.signalConditionsOfSatisfiedGuards(null);
            }
            this.incrementWaiters(guard);
            try {
                Condition condition = guard.condition;
                do {
                    if (l <= 0L) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    try {
                        l = condition.awaitNanos(l);
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            this.signalConditionsOfSatisfiedGuards(guard);
                        }
                        catch (Throwable throwable) {
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate(throwable);
                        }
                        throw interruptedException;
                    }
                } while (!guard.isSatisfied());
            }
            finally {
                this.decrementWaiters(guard);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private boolean waitUninterruptibly(Guard guard, long l, boolean bl) {
        if (!guard.isSatisfied()) {
            long l2 = System.nanoTime();
            if (bl) {
                this.signalConditionsOfSatisfiedGuards(null);
            }
            boolean bl2 = false;
            try {
                this.incrementWaiters(guard);
                try {
                    Condition condition = guard.condition;
                    long l3 = l;
                    do {
                        if (l3 <= 0L) {
                            boolean bl3 = false;
                            return bl3;
                        }
                        try {
                            l3 = condition.awaitNanos(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            try {
                                this.signalConditionsOfSatisfiedGuards(guard);
                            }
                            catch (Throwable throwable) {
                                Thread.currentThread().interrupt();
                                throw Throwables.propagate(throwable);
                            }
                            bl2 = true;
                            l3 = l - (System.nanoTime() - l2);
                        }
                    } while (!guard.isSatisfied());
                }
                finally {
                    this.decrementWaiters(guard);
                }
            }
            finally {
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    @Beta
    public static abstract class Guard {
        final Monitor monitor;
        final Condition condition;
        @GuardedBy(value="monitor.lock")
        int waiterCount = 0;

        protected Guard(Monitor monitor) {
            this.monitor = Preconditions.checkNotNull(monitor, "monitor");
            this.condition = monitor.lock.newCondition();
        }

        public abstract boolean isSatisfied();

        public final boolean equals(Object object) {
            return this == object;
        }

        public final int hashCode() {
            return super.hashCode();
        }
    }
}

