/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Uninterruptibles {
    public static void awaitUninterruptibly(CountDownLatch countDownLatch) {
        boolean bl = false;
        while (true) {
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, long l, TimeUnit timeUnit) {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    boolean bl2 = countDownLatch.await(l2, TimeUnit.NANOSECONDS);
                    return bl2;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void joinUninterruptibly(Thread thread) {
        boolean bl = false;
        while (true) {
            try {
                thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            try {
                V v = future.get();
                return v;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <V> V getUninterruptibly(Future<V> future, long l, TimeUnit timeUnit) throws ExecutionException, TimeoutException {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                V v;
                try {
                    v = future.get(l2, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                return v;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void joinUninterruptibly(Thread thread, long l, TimeUnit timeUnit) {
        Preconditions.checkNotNull(thread);
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.timedJoin(thread, l2);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <E> E takeUninterruptibly(BlockingQueue<E> blockingQueue) {
        boolean bl = false;
        while (true) {
            try {
                E e = blockingQueue.take();
                return e;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <E> void putUninterruptibly(BlockingQueue<E> blockingQueue, E e) {
        boolean bl = false;
        while (true) {
            try {
                blockingQueue.put(e);
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void sleepUninterruptibly(long l, TimeUnit timeUnit) {
        boolean bl = false;
        try {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(l2);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Uninterruptibles() {
    }
}

