/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

public class ComparisonCompactor {
    private static final String ELLIPSIS = "...";
    private static final String DELTA_END = "]";
    private static final String DELTA_START = "[";
    private int fContextLength;
    private String fExpected;
    private String fActual;
    private int fPrefix;
    private int fSuffix;

    public ComparisonCompactor(int n, String string, String string2) {
        this.fContextLength = n;
        this.fExpected = string;
        this.fActual = string2;
    }

    public String compact(String string) {
        if (this.fExpected == null || this.fActual == null || this.areStringsEqual()) {
            return ComparisonCompactor.format(string, this.fExpected, this.fActual);
        }
        this.findCommonPrefix();
        this.findCommonSuffix();
        String string2 = this.compactString(this.fExpected);
        String string3 = this.compactString(this.fActual);
        return ComparisonCompactor.format(string, string2, string3);
    }

    private String compactString(String string) {
        String string2 = DELTA_START + string.substring(this.fPrefix, string.length() - this.fSuffix + 1) + DELTA_END;
        if (this.fPrefix > 0) {
            string2 = this.computeCommonPrefix() + string2;
        }
        if (this.fSuffix > 0) {
            string2 = string2 + this.computeCommonSuffix();
        }
        return string2;
    }

    private void findCommonPrefix() {
        this.fPrefix = 0;
        int n = Math.min(this.fExpected.length(), this.fActual.length());
        while (this.fPrefix < n && this.fExpected.charAt(this.fPrefix) == this.fActual.charAt(this.fPrefix)) {
            ++this.fPrefix;
        }
    }

    private void findCommonSuffix() {
        int n = this.fExpected.length() - 1;
        for (int i = this.fActual.length() - 1; i >= this.fPrefix && n >= this.fPrefix && this.fExpected.charAt(n) == this.fActual.charAt(i); --i, --n) {
        }
        this.fSuffix = this.fExpected.length() - n;
    }

    private String computeCommonPrefix() {
        return (this.fPrefix > this.fContextLength ? ELLIPSIS : "") + this.fExpected.substring(Math.max(0, this.fPrefix - this.fContextLength), this.fPrefix);
    }

    private String computeCommonSuffix() {
        int n = Math.min(this.fExpected.length() - this.fSuffix + 1 + this.fContextLength, this.fExpected.length());
        return this.fExpected.substring(this.fExpected.length() - this.fSuffix + 1, n) + (this.fExpected.length() - this.fSuffix + 1 < this.fExpected.length() - this.fContextLength ? ELLIPSIS : "");
    }

    private boolean areStringsEqual() {
        return this.fExpected.equals(this.fActual);
    }

    private static String format(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string + " ";
        }
        return string2 + "expected:<" + object + "> but was:<" + object2 + ">";
    }
}

